# !bin/bash

cd ./experiments

dset=$1
path=$2
gpu=0
if [ $# == 3 ]; then
    gpu=$3
fi


if [ $1 == 'office' ]; then
    ls=( 'amazon' 'dslr' 'webcam' )
fi
if [ $1 == 'office-home' ]; then
    ls=( 'Art' 'Clipart' 'Product' 'RealWorld' )
fi
if [ $1 == 'office-caltech' ]; then
    ls=( 'amazon' 'caltech' 'dslr' 'webcam' )
fi
if [ $1 == 'imageCLEF' ]; then
    ls=( 'C' 'I' 'P' )
fi



for ((s=0;s<${#ls[*]};s=s+1))
do
src=${ls[${s}]}
echo "=====src ${src} training...====="
python ./train_large_src.py --trte val --net 'resnet50' --output ckps/source/ --da uda --dset ${dset} --max_epoch 100 --s ${s} --src ${src} --root_path ${path} --tar ${ls[0]} --gpu_id ${gpu}
python ./train_large_tar.py --cls_par 0.3 --batch_size 8 --net 'resnet50' --DA_max_epoch 20 --da uda --gpu_id ${gpu}  --output_src ckps/source/ --output ckps/target/lite/ --s ${s} --src ${src} --dset ${dset} --root_path ${path}
done
cd ..