import numpy as np

def generate_kmeans_block(r=1,alpha=50,offsetx=0,offsety=0):
    return np.array([
        [offsetx, offsety],
        [offsetx+r,offsety],
        [offsetx,offsety+alpha*r],
        [offsetx,offsety-alpha*r]
            ])

def generate_kmeans_instance(n_alpha = 20000, r=1,alpha=50):
    eps = 1.0/ (100 * alpha)
    d_alpha = alpha * r * ((3*n_alpha/eps)**0.5)
    instance = generate_kmeans_block(r=r,alpha=alpha)
    for i in range(1, n_alpha):
        block = generate_kmeans_block(r=r,alpha=alpha,offsetx = d_alpha*i)
        instance= np.concatenate((instance,block))
    return instance

