from all2.agents import Agent


class Body(Agent):
    """
    A Body wraps a reinforcement learning Agent, altering its inputs and outputs.

    The Body API is identical to the Agent API from the perspective of the
    rest of the system. This base class is provided only for semantic clarity.
    """

    def __init__(self, agent):
        self._agent = agent

    @property
    def cur_n_update_actions(self):
        return self._agent.cur_n_update_actions
    

    @property
    def agent(self):
        return self._agent

    @agent.setter
    def agent(self, agent):
        self._agent = agent

    def act(self, states):
        if type(states) == list:
            return self.process_action(self.agent.act([self.process_state(states[0], should_stack=True)] + [self.process_state(states[1])]))
        else:
            return self.process_action(self.agent.act(self.process_state(states, should_stack=True)))

    def eval(self, state):
        return self.process_action(self.agent.eval(self.process_state(state, should_stack=True)))

    def process_state(self, state, should_stack=False):
        return state

    def process_action(self, action):
        return action
