import argparse
from all2.environments import GymEnvironment
from all2.experiments import run_experiment
from preset import jointdqn_cartpole, jointdqn_mc
from all2.presets.classic_control import c51, dqn

import torch
import numpy as np


def set_seed(seed):    
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False

def run():
    # parse arguments
    parser = argparse.ArgumentParser()
    parser.add_argument("env", default="CartPole-v0")
    parser.add_argument(
        "--device",
        default="cuda:0",
        help="The name of the device to run the agent on (e.g. cpu, cuda, cuda:0)",
    )
    parser.add_argument(
        "--frames", type=int, default=200000, help="The number of training frames"
    )

    parser.add_argument("--seed", type=int, default=0)
    args = parser.parse_args()

    # create atari environment
    env = GymEnvironment(args.env, device=args.device, legacy_gym=True)
    print(f"Running with seed {args.seed}")
    set_seed(args.seed)

    # run the experiment
    run_experiment(jointdqn_cartpole.device(args.device), env, args.frames)

if __name__ == "__main__":
    run()
