# Cyclic Sparse Training: Is it Enough?

This directory contains the code required to replicate all experiments in the paper.

A brief description of the files and directories:

1. **configs/:** Folder containing configuration files for args that are used across experiments.
2. **data/:** Folder containing scripts related to data-loading for training the models.
3. **models/:** Model definitions 
4. **utils/:** Miscellaneous utils required to run experiments including logs, model building etc.,
5. **args.py:** argument parser for training harness.
6. **main.py:** Main file for running experiments.
7. **pruners.py:** Contains additional pruning criterion for usage in lottery ticket experiments.
8. **trainer.py:** defintion of trainer used across all experiments.

### Datasets Supported:
1. CIFAR10
2. CIFAR100
3. ImageNet

### Models Supported:
1. ResNet18
2. ResNet20

### Requirements
1. All requirements can be installed via the requirements.txt
2. For ImageNet experiments FFCV needs to be installed, please follow instructions provided [here](https://github.com/libffcv/ffcv-imagenet).

An example command is as follows:

To run learning rate rewinding for multiple levels:

Save the following in a python file, say experiment.py

```python
import subprocess
import numpy as np

density = 0.005
prune_frac = 0.8
for seed in [1, 2, 3]:
    f = density
    L = int((np.log(density) - np.log(er_density))/ np.log(prune_frac))
    l = np.arange(1, L + 1)
    y = er_density * prune_frac ** l
    y_str = "".join(str(elem)+ ' ' for elem in y) 
    subprocess.call('python main.py --seed '+ str(seed) +' --resnet-type res20 --batch-size 512 --config configs/largescale/resnet18-cifar-str-1.yaml --threshold-list '+str(y_str)+' --multigpu 0 --pruner mag --er-sparse-method none --er-sparse-init 1 --name cifar-lrr --final_prune_epoch 150 --epochs 160 --result-dir cifar100-sparse-to-sparse --warmup-epochs 0 --prune-scheduler step-warmup --expt-setup current --lr 0.1', shell=True)

```

Then run as 

```bash
python experiment.py
```

