"""
Dummy class to wrap a transformer/nn.Module
model in a dummy instance so model.module doesn't throw errors.
"""

import torch

class DummyDistributed(torch.nn.Module):
    def __init__(self, model):
        super(DummyDistributed, self).__init__()
        self.module = model

    def forward(self, *args, **kwargs):
        return self.module(*args, **kwargs)