#!/usr/bin/env python3
from imputation_exp import imputation_exp
from datetime import datetime
import pandas as pd


def main():
    pooling_method_l = ['weighted_average', 'max', 'sum', 'mean', 'last', 'attention']

    seed_l = [42, 43, 44, 45, 46]
    # seed_l = [42]

    dataset_folder = '../data/Timeseries-PILE/forecasting/autoformer'
    dataset_name_l = ['ETTh1', 'ETTh2', 'ETTm1', 'ETTm2', 'weather', 'electricity', 'traffic',]

    model_size_l = ['small', 'base', 'large']

    batch_size = 64
    lr = 1e-3
    train_epoch = 10

    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    result_folder = './results/imputation/'
    
    optimizer = 'adam'
    
    results = imputation_exp.run_exp(
        pooling_method_l=pooling_method_l,
        model_size_l=model_size_l,
        seed_l=seed_l,
        dataset_folder=dataset_folder,
        dataset_name_l=dataset_name_l,
        train_epoch=train_epoch, 
        optimizer_name=optimizer,
        batch_size=batch_size,
        lr=lr,
        result_folder=result_folder,
        use_mixed_precision=True,
        only_OT=True,
        timestamp=timestamp,
    )

    results_df = pd.DataFrame(results)

    csv_filename = f'cls_results_{timestamp}.csv'
    results_df.to_csv(csv_filename, index=False)
    print(f"Results saved to {csv_filename}")

if __name__ == '__main__':
    main()
