import os

from setuptools import find_packages, setup, Command

def parse_requirements(filename):
    with open(filename, "r") as f:
        return [line.strip() for line in f if line.strip() and not line.startswith("#")]

# REQUIRED_PACKAGES = [
#     "matplotlib>=3.9.4",
#     "hydra-core==1.3.2",
#     "google-cloud-aiplatform<2.0",
#     "cloudml-hypertune==0.1.0.dev6",
#     "numpy>=2.1.3",
#     "pandas>=2.2.3",
#     "torch>=2.5.1",
#     "torchvision>=0.20.1",
#     "tqdm>=4.62.3",
#     "hydra-joblib-launcher>=1.2.0",
#     "transformers>=4.47",
#     "accelerate>=1.4.0",
#     "datasets>=2.2",
#     "scipy>=1.15",
#     "mteb>=1.35", #MTEB benchmark
#     "tiktoken>=0.9.0", #TikToken tokenizer for NanoGPT
#     "gcsfs>=3.2.0"  # GCS file system for Google Cloud Storage
# ]

REQUIRED_PACKAGES = parse_requirements("requirements.txt")

DEV_PACKAGES = [
    "ipykernel>=6.29.5",
]


class CleanCommand(Command):
    """Custom clean command to tidy up the project root."""

    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        os.system("rm -vrf ./build ./dist ./*.pyc ./*.tgz ./*.egg-info")


setup(
    name="pooling",
    version="0.1.0",
    description="",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    python_requires=">=3.11",
    install_requires=REQUIRED_PACKAGES,
    extras_require={
        "dev": DEV_PACKAGES,
    },
    packages=find_packages(),
    package_data={"": ["**/*.yaml", "**/*.txt"]},
    include_package_data=True,
    zip_safe=False,
    cmdclass={
        "clean": CleanCommand,
    },
)