import datasets
import torch

class TweetSentimentExtractionDataset(torch.utils.data.Dataset):
    def __init__(self, split):
        self.dataset = datasets.load_dataset("mteb/tweet_sentiment_extraction", split=split, trust_remote_code=True)

    def __len__(self):
        return len(self.dataset)

    @property
    def num_classes(self):
        return 3  # Positive, negative, neutral

    def __getitem__(self, idx):
        sample = self.dataset[idx]
        text = sample["text"]  # The tweet text
        label = sample["label"]  # The sentiment label (e.g., positive, negative, neutral)
        return text, label


