#!/bin/bash

baselines="random scaml gp mtgp"
# baselines="random"

# pfn_ids="hardy-donkey-635"

pfn_ids="glorious-dream-660
earthy-voice-659
rosy-yogurt-658
pleasant-firefly-657
neat-universe-656
valiant-pyramid-655
wandering-brook-654"
# light-sun-651
# restful-water-651
# effortless-wood-651
# logical-yogurt-644
# comic-dream-644
# swift-dawn-644
# grateful-oath-645
# legendary-spaceship-644
# valiant-aardvark-644"

# pfn_ids="astral-serenity-610 distinctive-totem-607 frosty-thunder-609 polar-resonance-603 firm-mountain-602 ruby-frog-605"
# pfn_ids="major-durian-607"

# ckpt_dirs="ckpt/sam_hier ckpt/sam_onehot"
# ckpt_dirs="ckpt/sam_7_4 ckpt/sam_7_20"
# ckpt_dirs="ckpt/sam_7_4 ckpt/sam_low_rank"

n_trials=3
n_functions=3

cmds=(
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark fcnet --bo_iters 50 --n_trials $n_trials --n_functions $n_functions --fcnet_n_features 5"

    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task rf --hpobench_n_features 5 --hpobench_n_tasks 4 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task xgb --hpobench_n_features 5 --hpobench_n_tasks 4 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task svm --hpobench_n_features 5 --hpobench_n_tasks 4 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task lr --hpobench_n_features 5 --hpobench_n_tasks 4 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task nn --hpobench_n_features 5 --hpobench_n_tasks 4 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"

    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark synthetic --suite paper --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"

    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark lcbench --n_trials $n_trials --n_functions $n_functions --lcbench_id 0"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark lcbench --n_trials $n_trials --n_functions $n_functions --lcbench_id 1"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark lcbench --n_trials $n_trials --n_functions $n_functions --lcbench_id 2"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark lcbench --n_trials $n_trials --n_functions $n_functions --lcbench_id 3"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark lcbench --n_trials $n_trials --n_functions $n_functions --lcbench_id 4"

    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task rf --hpobench_n_features 5 --hpobench_n_tasks 20 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task xgb --hpobench_n_features 5 --hpobench_n_tasks 20 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task svm --hpobench_n_features 5 --hpobench_n_tasks 20 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task lr --hpobench_n_features 5 --hpobench_n_tasks 20 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
    "python eval.py --pfn_ids $pfn_ids --ckpt_dirs $ckpt_dirs --baselines $baselines --benchmark hpobench --hpobench_task nn --hpobench_n_features 5 --hpobench_n_tasks 20 --bo_iters 50 --n_trials $n_trials --n_functions $n_functions"
)

for cmd in "${cmds[@]}"; do
    echo "Running: $cmd"
    eval $cmd
done