/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.ClosenessCentrality;
import edu.uci.ics.jung.algorithms.scoring.util.VertexScoreTransformer;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.Collection;

public class DistanceStatistics {
    public static <V, E> Function<V, Double> averageDistances(Hypergraph<V, E> graph, Distance<V> d) {
        ClosenessCentrality<V, E> cc = new ClosenessCentrality<V, E>(graph, d);
        return new VertexScoreTransformer<V, E>(cc);
    }

    public static <V, E> Function<V, Double> averageDistances(Hypergraph<V, E> g2) {
        ClosenessCentrality<V, E> cc = new ClosenessCentrality<V, E>(g2, new UnweightedShortestPath<V, E>(g2));
        return new VertexScoreTransformer<V, E>(cc);
    }

    public static <V, E> double diameter(Hypergraph<V, E> g2, Distance<V> d, boolean use_max) {
        double diameter = 0.0;
        Collection<V> vertices = g2.getVertices();
        for (V v : vertices) {
            for (V w : vertices) {
                if (v.equals(w)) continue;
                Number dist = d.getDistance(v, w);
                if (dist == null) {
                    if (use_max) continue;
                    return Double.POSITIVE_INFINITY;
                }
                diameter = Math.max(diameter, dist.doubleValue());
            }
        }
        return diameter;
    }

    public static <V, E> double diameter(Hypergraph<V, E> g2, Distance<V> d) {
        return DistanceStatistics.diameter(g2, d, false);
    }

    public static <V, E> double diameter(Hypergraph<V, E> g2) {
        return DistanceStatistics.diameter(g2, new UnweightedShortestPath<V, E>(g2));
    }
}

