/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.codegenerator;

import info.scce.addlib.codegenerator.LabelTransformMode;
import info.scce.addlib.dd.DDException;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class CodeGenerator<D extends RegularDD<?, D>> {
    private static final String STANDARD_VAR_NAMES_REGEX = "[a-zA-Z]\\w*";
    private Map<Integer, String> cache;
    private Set<String> labelsSet;
    private LabelTransformMode labelTransformMode = LabelTransformMode.FORBID_SPECIAL;

    public void setLabelTransformMode(LabelTransformMode labelTransformMode) {
        this.labelTransformMode = labelTransformMode;
    }

    public String generateToString(D root, String label) {
        return this.generateToString(new LabelledRegularDD<D>(root, label));
    }

    public String generateToString(LabelledRegularDD<D> root) {
        return this.generateToString(Collections.singletonList(root));
    }

    public String generateToString(List<LabelledRegularDD<D>> roots) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.generate((OutputStream)baos, roots);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public void generateToFileSystem(File target, D root, String label) throws IOException {
        this.generateToFileSystem(target, new LabelledRegularDD<D>(root, label));
    }

    public void generateToFileSystem(File target, String cs, D root, String label) throws IOException {
        this.generateToFileSystem(target, cs, new LabelledRegularDD<D>(root, label));
    }

    public void generateToFileSystem(File target, LabelledRegularDD<D> root) throws IOException {
        this.generateToFileSystem(target, Collections.singletonList(root));
    }

    public void generateToFileSystem(File target, String cs, LabelledRegularDD<D> root) throws IOException {
        this.generateToFileSystem(target, cs, Collections.singletonList(root));
    }

    public void generateToFileSystem(File target, List<LabelledRegularDD<D>> roots) throws IOException {
        try (PrintWriter pw = IOUtils.getBufferedPrintWriterUTF8(target);){
            this.generate(pw, roots);
        }
    }

    public void generateToFileSystem(File target, String cs, List<LabelledRegularDD<D>> roots) throws IOException {
        try (PrintWriter ps = IOUtils.getBufferedPrintWriterCS(target, cs);){
            this.generate(ps, roots);
        }
    }

    public void generateToStdOut(D root, String label) {
        this.generateToStdOut(new LabelledRegularDD<D>(root, label));
    }

    public void generateToStdOut(String cs, D root, String label) throws UnsupportedEncodingException {
        this.generateToStdOut(cs, new LabelledRegularDD<D>(root, label));
    }

    public void generateToStdOut(LabelledRegularDD<D> root) {
        this.generateToStdOut(Collections.singletonList(root));
    }

    public void generateToStdOut(String cs, LabelledRegularDD<D> root) throws UnsupportedEncodingException {
        this.generateToStdOut(cs, Collections.singletonList(root));
    }

    public void generateToStdOut(List<LabelledRegularDD<D>> roots) {
        this.generate((OutputStream)System.out, roots);
        System.out.flush();
    }

    public void generateToStdOut(String cs, List<LabelledRegularDD<D>> roots) throws UnsupportedEncodingException {
        this.generate((OutputStream)System.out, cs, roots);
        System.out.flush();
    }

    public void generate(OutputStream out, D root, String label) {
        this.generate(out, new LabelledRegularDD<D>(root, label));
    }

    public void generate(OutputStream out, String cs, D root, String label) throws UnsupportedEncodingException {
        this.generate(out, cs, new LabelledRegularDD<D>(root, label));
    }

    public void generate(OutputStream out, LabelledRegularDD<D> root) {
        this.generate(out, Collections.singletonList(root));
    }

    public void generate(OutputStream out, String cs, LabelledRegularDD<D> root) throws UnsupportedEncodingException {
        this.generate(out, cs, Collections.singletonList(root));
    }

    public void generate(OutputStream out, List<LabelledRegularDD<D>> roots) {
        PrintWriter pw = IOUtils.getOutputStreamPrintWriterUTF8(out);
        this.generate(pw, roots);
        pw.flush();
    }

    public void generate(OutputStream out, String cs, List<LabelledRegularDD<D>> roots) {
        PrintWriter ps = IOUtils.getOutputStreamPrintWriterCS(out, cs);
        this.generate(ps, roots);
        ps.flush();
    }

    public abstract void generate(PrintWriter var1, List<LabelledRegularDD<D>> var2);

    protected List<D> unlabelledRoots(List<LabelledRegularDD<D>> roots) {
        return roots.stream().map(LabelledRegularDD::dd).collect(Collectors.toList());
    }

    protected String transformToValidLabel(String label, int index) {
        String cachedTransformedLabel;
        if (this.cache == null || this.labelsSet == null) {
            this.cache = new HashMap<Integer, String>();
            this.labelsSet = new HashSet<String>();
        }
        if ((cachedTransformedLabel = this.cache.get(index)) != null) {
            return cachedTransformedLabel;
        }
        if (this.labelTransformMode == LabelTransformMode.FORBID_SPECIAL && !label.matches(STANDARD_VAR_NAMES_REGEX)) {
            throw new DDException("Variable names must be of the form [a-zA-Z]\\w* for the generator but " + label + " is not");
        }
        String validLabel = label.replace(" ", "");
        Matcher matcher = Pattern.compile("[^a-zA-Z0-9_]").matcher(validLabel);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            StringBuilder unicode = new StringBuilder();
            if (this.labelTransformMode != LabelTransformMode.DISCARD_SPECIAL) {
                for (int i = matcher.start(); i < matcher.end(); ++i) {
                    unicode.append(String.format("%#06x", validLabel.charAt(i)));
                }
            }
            matcher.appendReplacement(stringBuffer, unicode.toString());
        }
        matcher.appendTail(stringBuffer);
        validLabel = stringBuffer.toString();
        if (validLabel.length() == 0 || !String.valueOf(validLabel.charAt(0)).matches("[a-zA-Z]")) {
            validLabel = "var" + validLabel;
        }
        if (this.labelsSet.contains(validLabel)) {
            int id = 1;
            while (this.labelsSet.contains(validLabel + "v" + id)) {
                ++id;
            }
            validLabel = validLabel + index;
        }
        this.cache.put(index, validLabel);
        this.labelsSet.add(validLabel);
        return validLabel;
    }
}

