/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BooleanVector {
    private final boolean[] b;

    public BooleanVector(boolean ... b) {
        this.b = b;
    }

    public static BooleanVector zero(int n) {
        boolean[] b = new boolean[n];
        return new BooleanVector(b);
    }

    public static BooleanVector one(int n) {
        boolean[] b = new boolean[n];
        Arrays.fill(b, true);
        return new BooleanVector(b);
    }

    public static BooleanVector parseBooleanVector(String str) {
        boolean[] b;
        String strCommaSeparatedBools = str.substring(1, str.length() - 1);
        if (strCommaSeparatedBools.isEmpty()) {
            b = new boolean[]{};
        } else {
            String[] strBools = strCommaSeparatedBools.split(", ");
            b = new boolean[strBools.length];
            for (int i = 0; i < b.length; ++i) {
                b[i] = Boolean.parseBoolean(strBools[i]);
            }
        }
        return new BooleanVector(b);
    }

    public int n() {
        return this.b.length;
    }

    public boolean[] data() {
        return (boolean[])this.b.clone();
    }

    public BooleanVector not() {
        boolean[] negation = new boolean[this.b.length];
        for (int i = 0; i < this.b.length; ++i) {
            negation[i] = !this.b[i];
        }
        return new BooleanVector(negation);
    }

    public BooleanVector and(BooleanVector other) {
        boolean[] conjunction = new boolean[this.b.length];
        for (int i = 0; i < this.b.length; ++i) {
            conjunction[i] = this.b[i] && other.b[i];
        }
        return new BooleanVector(conjunction);
    }

    public BooleanVector or(BooleanVector other) {
        boolean[] disjunction = new boolean[this.b.length];
        for (int i = 0; i < this.b.length; ++i) {
            disjunction[i] = this.b[i] || other.b[i];
        }
        return new BooleanVector(disjunction);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanVector bnLogic = (BooleanVector)o;
        return Arrays.equals(this.b, bnLogic.b);
    }

    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    public String toString() {
        return Arrays.toString(this.b);
    }
}

