/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Partition<T> {
    private final Set<Set<T>> blocks;

    public Partition() {
        this.blocks = new HashSet<Set<T>>();
    }

    public Partition(T ... block0) {
        this.blocks = new HashSet<Set<T>>();
        this.blocks.add(new HashSet<T>(Arrays.asList(block0)));
    }

    private Partition(Set<Set<T>> blocks) {
        this.blocks = blocks;
    }

    public static <T> Partition<T> emptyPartition() {
        return new Partition<T>();
    }

    public int size() {
        return this.blocks.size();
    }

    public Set<Set<T>> blocks() {
        return new HashSet<Set<T>>(this.blocks);
    }

    public Partition<T> meet(Partition<T> other) {
        HashSet<Set<T>> meetBlocks = new HashSet<Set<T>>();
        LinkedList<@NonNull Set<T>> q0 = new LinkedList<Set<T>>(this.blocks);
        LinkedList<Set<T>> q1 = new LinkedList<Set<T>>(other.blocks);
        while (!q0.isEmpty()) {
            HashSet b0 = new HashSet(q0.remove());
            ListIterator it = q1.listIterator();
            while (it.hasNext()) {
                HashSet b1 = new HashSet((Collection)it.next());
                if (b0.equals(b1)) {
                    it.remove();
                    continue;
                }
                if (!this.intersectionNotEmpty(b0, b1)) continue;
                Set intersection = this.intersect(b0, b1);
                b0.removeAll(intersection);
                b1.removeAll(intersection);
                it.remove();
                if (!b1.isEmpty()) {
                    it.add(b1);
                }
                it.add(intersection);
            }
            if (b0.isEmpty()) continue;
            meetBlocks.add(b0);
        }
        meetBlocks.addAll(q1);
        return new Partition<T>(meetBlocks);
    }

    public static <T> Partition<T> parsePartition(String str, Function<String, T> parseElement) {
        if ("[]".equals(str)) {
            return new Partition<T>();
        }
        String strCommaSeparatedBlocks = str.substring(2, str.length() - 2);
        String[] strBlocks = strCommaSeparatedBlocks.split("], \\[");
        HashSet<Set<T>> blocks = new HashSet<Set<T>>();
        for (String strCommaSeparatedElems : strBlocks) {
            String[] strElems = strCommaSeparatedElems.split(", ");
            HashSet<T> b = new HashSet<T>();
            for (String strElem : strElems) {
                T elem = parseElement.apply(strElem);
                b.add(elem);
            }
            blocks.add(b);
        }
        return new Partition<T>(blocks);
    }

    public Partition<T> join(Partition<T> other) {
        HashSet<Set<T>> joinBlocks = new HashSet<Set<T>>();
        LinkedList<@NonNull Set<T>> q0 = new LinkedList<Set<T>>(this.blocks);
        LinkedList<Set<T>> q1 = new LinkedList<Set<T>>(other.blocks);
        while (!q0.isEmpty()) {
            HashSet b0 = new HashSet(q0.remove());
            ListIterator it = q1.listIterator();
            while (it.hasNext()) {
                Set b1 = (Set)it.next();
                if (b0.equals(b1)) {
                    it.remove();
                    continue;
                }
                if (!this.intersectionNotEmpty(b0, b1)) continue;
                b0.addAll(b1);
                it.remove();
            }
            joinBlocks.add(b0);
        }
        joinBlocks.addAll(q1);
        return new Partition<T>(joinBlocks);
    }

    private boolean intersectionNotEmpty(Set<T> a, Set<T> b) {
        for (T x : a) {
            if (!b.contains(x)) continue;
            return true;
        }
        return false;
    }

    private Set<T> intersect(Set<T> a, Set<T> b) {
        HashSet<T> s2 = new HashSet<T>(a);
        s2.retainAll(b);
        return s2;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.blocks, partition.blocks);
    }

    public int hashCode() {
        return Objects.hash(this.blocks);
    }

    public String toString() {
        return "[" + this.blocks.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }
}

