/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.parser;

import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.dd.xdd.XDDManager;
import info.scce.addlib.parser.XDDLanguageBaseVisitor;
import info.scce.addlib.parser.XDDLanguageParser;
import org.checkerframework.checker.nullness.qual.Nullable;

public class XDDVisitor<E>
extends XDDLanguageBaseVisitor<XDD<E>> {
    private final XDDManager<E> ddManager;

    public XDDVisitor(XDDManager<E> ddManager) {
        this.ddManager = ddManager;
    }

    @Override
    public XDD<E> visitStart(XDDLanguageParser.StartContext ctx) {
        return (XDD)this.visit(ctx.ex);
    }

    @Override
    public XDD<E> visitInverseExpr(XDDLanguageParser.InverseExprContext ctx) {
        XDD child = (XDD)this.visit(ctx.ex);
        XDD result = child.inverse();
        child.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitComplExpr(XDDLanguageParser.ComplExprContext ctx) {
        XDD child = (XDD)this.visit(ctx.ex);
        XDD result = child.compl();
        child.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitNotExpr(XDDLanguageParser.NotExprContext ctx) {
        XDD child = (XDD)this.visit(ctx.ex);
        XDD result = child.not();
        child.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitMeetExpr(XDDLanguageParser.MeetExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.meet(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitInfExpr(XDDLanguageParser.InfExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.inf(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitIntersectExpr(XDDLanguageParser.IntersectExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.intersect(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitAndExpr(XDDLanguageParser.AndExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.and(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitMultExpr(XDDLanguageParser.MultExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.mult(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitJoinExpr(XDDLanguageParser.JoinExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.join(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitSupExpr(XDDLanguageParser.SupExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.sup(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitUnionExpr(XDDLanguageParser.UnionExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.union(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitOrExpr(XDDLanguageParser.OrExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.or(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitAddExpr(XDDLanguageParser.AddExprContext ctx) {
        XDD left = (XDD)this.visit(ctx.left);
        XDD right = (XDD)this.visit(ctx.right);
        XDD result = left.add(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public XDD<E> visitTerminalExpr(XDDLanguageParser.TerminalExprContext ctx) {
        String str = this.unescapeString(ctx.getText());
        if (str == null) {
            throw new IllegalArgumentException("The terminal expression context returns null!");
        }
        E terminal = this.ddManager.parseElement(str);
        return this.ddManager.constant(terminal);
    }

    private @Nullable String unescapeString(String str) {
        if (str.length() > 2) {
            char charFst = str.charAt(0);
            char charLst = str.charAt(str.length() - 1);
            String strBody = str.substring(1, str.length() - 1);
            if (charFst == charLst) {
                if (charFst == '\"') {
                    return strBody.replace("\\\"", "\"");
                }
                if (charFst == '\'') {
                    return strBody.replace("\\'", "'");
                }
            }
        }
        return null;
    }
}

