/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.KeyFor;

public abstract class DDDistributionMetrics {
    private Map<Integer, Integer> distribution;

    public int min() {
        this.getDistribution();
        int min2 = Integer.MAX_VALUE;
        for (Integer depth : this.distribution.keySet()) {
            if (min2 <= depth) continue;
            min2 = depth;
        }
        return min2;
    }

    public int max() {
        this.getDistribution();
        int max = 0;
        for (Integer depth : this.distribution.keySet()) {
            if (depth <= max) continue;
            max = depth;
        }
        return max;
    }

    public int median() {
        this.getDistribution();
        TreeSet<@KeyFor(value={"distribution"}) Integer> keys = new TreeSet<Integer>(this.distribution.keySet());
        int numElems = 0;
        for (Integer depth : keys) {
            numElems += this.distribution.get(depth).intValue();
        }
        int currElems = 0;
        for (Map.Entry<Integer, Integer> depthNumElems : this.distribution.entrySet()) {
            if ((currElems += depthNumElems.getValue().intValue()) * 2 < numElems) continue;
            return depthNumElems.getKey();
        }
        return -1;
    }

    public double mean() {
        this.getDistribution();
        int mean = 0;
        int numElems = 0;
        for (Map.Entry<Integer, Integer> depthNumElems : this.distribution.entrySet()) {
            mean += depthNumElems.getKey() * depthNumElems.getValue();
            numElems += depthNumElems.getValue().intValue();
        }
        return 1.0 * (double)mean / (double)numElems;
    }

    public double std() {
        this.getDistribution();
        double std = 0.0;
        int numElems = 0;
        double mean = this.mean();
        for (Map.Entry<Integer, Integer> depthNumElems : this.distribution.entrySet()) {
            std += (double)depthNumElems.getValue().intValue() * Math.pow((double)depthNumElems.getKey().intValue() - mean, 2.0);
            numElems += depthNumElems.getValue().intValue();
        }
        return Math.sqrt(std / (double)numElems);
    }

    protected abstract Map<Integer, Integer> generateDistribution();

    public Map<Integer, Integer> getDistribution() {
        if (this.distribution == null) {
            this.distribution = this.generateDistribution();
        }
        return new HashMap<Integer, Integer>(this.distribution);
    }
}

