/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collector;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.AlphabetCollector;
import net.automatalib.alphabet.ArrayAlphabet;
import net.automatalib.alphabet.EnumAlphabet;
import net.automatalib.alphabet.GrowingAlphabet;
import net.automatalib.alphabet.ListAlphabet;
import net.automatalib.alphabet.MapAlphabet;
import net.automatalib.alphabet.SingletonAlphabet;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;

public final class Alphabets {
    private Alphabets() {
    }

    @SafeVarargs
    public static <T> Alphabet<T> fromArray(T ... symbols) {
        return new ArrayAlphabet<T>(symbols);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz) {
        return Alphabets.fromEnum(enumClazz, false);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz, boolean withNull) {
        return new EnumAlphabet<E>(enumClazz, withNull);
    }

    public static Alphabet<Integer> integers(int startInclusive, int endInclusive) {
        List<Integer> lst = CollectionsUtil.intRange(startInclusive, endInclusive + 1);
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> fromList(List<? extends T> list) {
        return new ListAlphabet<T>(list);
    }

    public static Alphabet<Character> characters(char startInclusive, char endInclusive) {
        List<Character> lst = CollectionsUtil.charRange(startInclusive, (char)(endInclusive + '\u0001'));
        return Alphabets.fromList(lst);
    }

    public static Alphabet<String> closedCharStringRange(char startInclusive, char endInclusive) {
        List<String> lst = CollectionsUtil.charStringRange(startInclusive, (char)(endInclusive + '\u0001'));
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> singleton(T symbol) {
        return new SingletonAlphabet<T>(symbol);
    }

    public static <I> Alphabet<I> fromCollection(Collection<? extends I> coll) {
        if (coll instanceof Alphabet) {
            return (Alphabet)coll;
        }
        return new MapAlphabet<I>(coll);
    }

    @SafeVarargs
    public static <I> Alphabet<I> fromCollections(Collection<? extends I> ... colls) {
        ArrayList<? extends I> symbols = new ArrayList<I>();
        for (Collection<? extends I> coll : colls) {
            symbols.addAll(coll);
        }
        return new MapAlphabet(symbols);
    }

    public static <I> GrowingAlphabet<I> toGrowingAlphabetOrThrowException(Alphabet<I> alphabet) {
        if (alphabet instanceof GrowingAlphabet) {
            return (GrowingAlphabet)alphabet;
        }
        throw new GrowingAlphabetNotSupportedException(alphabet);
    }

    public static <I> Collector<I, ?, GrowingAlphabet<I>> collector() {
        return new AlphabetCollector();
    }
}

