/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.abstraction;

import java.util.function.IntFunction;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.simple.SimpleDeterministicAutomaton;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SimpleDeterministicAbstractions {

    public static class FullIntAbstraction<I, A extends SimpleDeterministicAutomaton.StateIntAbstraction<I>>
    implements SimpleDeterministicAutomaton.FullIntAbstraction {
        protected final A stateAbstraction;
        protected final int numInputs;
        protected final IntFunction<? extends I> symMapping;

        public FullIntAbstraction(A stateAbstraction, int numInputs, IntFunction<? extends I> symMapping) {
            this.stateAbstraction = stateAbstraction;
            this.numInputs = numInputs;
            this.symMapping = symMapping;
        }

        @Override
        public int getSuccessor(int state, int input) {
            return this.stateAbstraction.getSuccessor(state, this.intToSym(input));
        }

        @Override
        public int numInputs() {
            return this.numInputs;
        }

        protected final I intToSym(int input) {
            return this.symMapping.apply(input);
        }

        @Override
        public int size() {
            return this.stateAbstraction.size();
        }

        @Override
        public int getIntInitialState() {
            return this.stateAbstraction.getIntInitialState();
        }
    }

    public static class StateIntAbstraction<S, I, A extends SimpleDeterministicAutomaton<S, I>>
    extends IntAbstraction<S, A>
    implements SimpleDeterministicAutomaton.StateIntAbstraction<I> {
        public StateIntAbstraction(A automaton) {
            super(automaton);
        }

        @Override
        public int getSuccessor(int state, I input) {
            return this.safeStateToInt(this.automaton.getSuccessor(this.intToState(state), input));
        }
    }

    public static class IntAbstraction<S, A extends SimpleDeterministicAutomaton<S, ?>>
    implements SimpleDeterministicAutomaton.IntAbstraction {
        protected final A automaton;
        protected final StateIDs<S> stateIds;

        public IntAbstraction(A automaton) {
            this.automaton = automaton;
            this.stateIds = automaton.stateIDs();
        }

        @Override
        public int size() {
            return this.automaton.size();
        }

        protected final S intToState(int stateId) {
            return this.stateIds.getState(stateId);
        }

        protected final @Nullable S safeIntToState(int stateId) {
            return stateId == -1 ? null : (S)this.intToState(stateId);
        }

        @Override
        public int getIntInitialState() {
            return this.safeStateToInt(this.automaton.getInitialState());
        }

        protected final int stateToInt(S state) {
            return this.stateIds.getStateId(state);
        }

        protected final int safeStateToInt(@Nullable S state) {
            return state == null ? -1 : this.stateToInt(state);
        }
    }
}

