/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.base;

import java.util.Arrays;
import java.util.Iterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.base.AbstractCompact;
import net.automatalib.automaton.base.AbstractCompactDeterministic;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactSimpleDeterministic<I, SP>
extends AbstractCompactDeterministic<I, Integer, SP, Void> {
    protected int[] transitions;

    public AbstractCompactSimpleDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.transitions = new int[stateCapacity * this.numInputs()];
        Arrays.fill(this.transitions, -1);
    }

    protected AbstractCompactSimpleDeterministic(Alphabet<I> alphabet, AbstractCompactSimpleDeterministic<?, SP> other) {
        super(alphabet, (AbstractCompactDeterministic<?, ?, ?, ?>)other);
        this.transitions = (int[])other.transitions.clone();
    }

    @Override
    public Integer createTransition(int successor, Void property) {
        return successor;
    }

    @Override
    public @Nullable Integer getState(Iterable<? extends I> input) {
        return AbstractCompactSimpleDeterministic.toState(this.getIntSuccessor(this.getIntInitialState(), input));
    }

    @Override
    public @Nullable Integer getSuccessor(Integer state, Iterable<? extends I> input) {
        return AbstractCompactSimpleDeterministic.toState(this.getIntSuccessor(state, input));
    }

    @Override
    public @Nullable Integer getTransition(int state, int input) {
        return AbstractCompactSimpleDeterministic.toState(this.transitions[this.toMemoryIndex(state, input)]);
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, -1, payload);
    }

    @Override
    public void setTransitionProperty(Integer transition, Void property) {
    }

    @Override
    public void removeAllTransitions(Integer state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, -1);
    }

    @Override
    public void setTransition(int state, int input, @Nullable Integer transition) {
        this.setTransition(state, input, AbstractCompactSimpleDeterministic.toId(transition));
    }

    @Override
    public void setTransition(int state, int input, int successor, Void property) {
        this.setTransition(state, input, successor);
    }

    @Override
    public void setTransition(int state, int inputIdx, int succ) {
        this.transitions[this.toMemoryIndex((int)state, (int)inputIdx)] = succ;
    }

    @Override
    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.transitions, 0, this.size() * this.numInputs(), -1);
        super.clear();
    }

    @Override
    public int getIntSuccessor(Integer transition) {
        return AbstractCompactSimpleDeterministic.toId(transition);
    }

    private int getIntSuccessor(int state, Iterable<? extends I> input) {
        int current = state;
        Iterator<I> inputIt = input.iterator();
        while (current >= 0 && inputIt.hasNext()) {
            current = this.transitions[this.toMemoryIndex(current, this.getSymbolIndex(inputIt.next()))];
        }
        return current;
    }
}

