/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.fsa;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.automaton.UniversalAutomaton;
import net.automatalib.automaton.concept.OutputAutomaton;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.graph.UniversalAutomatonGraphView;
import net.automatalib.automaton.visualization.FSAVisualizationHelper;
import net.automatalib.graph.UniversalGraph;
import net.automatalib.ts.acceptor.AcceptorTS;
import net.automatalib.visualization.VisualizationHelper;

public interface FiniteStateAcceptor<S, I>
extends AcceptorTS<S, I>,
UniversalAutomaton<S, I, S, Boolean, Void>,
OutputAutomaton<S, I, S, Boolean>,
SuffixOutput<I, Boolean> {
    public static final List<Boolean> STATE_PROPERTIES = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
    public static final List<Void> TRANSITION_PROPERTIES = Collections.singletonList(null);

    @Override
    default public Boolean computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
        Iterable<? extends I> input = Iterables.concat(prefix, suffix);
        return this.computeOutput((Iterable)input);
    }

    @Override
    default public Boolean computeOutput(Iterable<? extends I> input) {
        return this.accepts(input);
    }

    @Override
    default public UniversalGraph<S, TransitionEdge<I, S>, Boolean, TransitionEdge.Property<I, Void>> transitionGraphView(Collection<? extends I> inputs) {
        return new FSAGraphView(this, inputs);
    }

    public static class FSAGraphView<S, I, A extends FiniteStateAcceptor<S, I>>
    extends UniversalAutomatonGraphView<S, I, S, Boolean, Void, A> {
        public FSAGraphView(A automaton, Collection<? extends I> inputs) {
            super(automaton, inputs);
        }

        @Override
        public VisualizationHelper<S, TransitionEdge<I, S>> getVisualizationHelper() {
            return new FSAVisualizationHelper((FiniteStateAcceptor)this.automaton);
        }
    }
}

