/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.Output;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.automaton.procedural.ProceduralSystem;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public interface SPMM<S, I, T, O>
extends ProceduralSystem<I, MealyMachine<?, I, ?, O>>,
MealyTransitionSystem<S, I, T, O>,
SuffixOutput<I, Word<O>> {
    public O getErrorOutput();

    default public boolean isErrorOutput(O output) {
        return Objects.equals(this.getErrorOutput(), output);
    }

    @Override
    default public Collection<I> getProceduralInputs(Collection<I> constraints) {
        Alphabet alphabet = this.getInputAlphabet();
        Map procedures = this.getProcedures();
        ArrayList<I> result = new ArrayList<I>(Math.min(alphabet.size(), constraints.size()));
        for (I i : constraints) {
            if (!procedures.containsKey(i) && !alphabet.isInternalSymbol(i) && !alphabet.isReturnSymbol(i)) continue;
            result.add(i);
        }
        return result;
    }

    @Override
    default public Word<O> computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
        Object state = this.getState(prefix);
        if (state == null) {
            return Word.epsilon();
        }
        WordBuilder result = Output.getBuilderFor(suffix);
        this.trace(state, suffix, result);
        return result.toWord();
    }
}

