/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.visualization;

import java.util.Map;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.transducer.SubsequentialTransducer;
import net.automatalib.automaton.visualization.AutomatonVisualizationHelper;
import net.automatalib.word.Word;

public class SSTVisualizationHelper<S, I, T, O>
extends AutomatonVisualizationHelper<S, I, T, SubsequentialTransducer<S, I, T, O>> {
    public SSTVisualizationHelper(SubsequentialTransducer<S, I, T, O> automaton) {
        super(automaton);
    }

    @Override
    public boolean getEdgeProperties(S src, TransitionEdge<I, T> edge, S tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        Word output = (Word)((SubsequentialTransducer)this.automaton).getTransitionProperty(edge.getTransition());
        properties.put("label", edge.getInput() + " / " + output);
        return true;
    }

    @Override
    public boolean getNodeProperties(S node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        String oldLabel = properties.get("label");
        properties.put("label", oldLabel + " / " + ((SubsequentialTransducer)this.automaton).getStateProperty(node));
        return true;
    }
}

