/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph;

import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.graph.base.AbstractCompactGraph;
import net.automatalib.graph.base.CompactEdge;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactGraph<@Nullable NP, @Nullable EP>
extends AbstractCompactGraph<CompactEdge<EP>, NP, EP> {
    private final ResizingArrayStorage<NP> nodeProperties;

    public CompactGraph() {
        this.nodeProperties = new ResizingArrayStorage<Object>(Object.class);
    }

    public CompactGraph(int initialCapacity) {
        super(initialCapacity);
        this.nodeProperties = new ResizingArrayStorage<Object>(Object.class, initialCapacity);
    }

    @Override
    public void setNodeProperty(int node, @Nullable NP property) {
        this.nodeProperties.ensureCapacity(node + 1);
        this.nodeProperties.array[node] = property;
    }

    @Override
    public NP getNodeProperty(int node) {
        return node < this.nodeProperties.array.length ? (NP)this.nodeProperties.array[node] : null;
    }

    @Override
    protected CompactEdge<EP> createEdge(int source, int target, @Nullable EP property) {
        return new CompactEdge<EP>(target, property);
    }
}

