/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.dag;

import java.util.Arrays;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.dag.State;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StateSignature {
    final ResizingArrayStorage<State> successors;
    Acceptance acceptance;
    private int hashCode;

    StateSignature(int numSuccs, Acceptance acceptance) {
        this.successors = new ResizingArrayStorage<State>(State.class, numSuccs);
        this.acceptance = acceptance;
        this.updateHashCode();
    }

    StateSignature(StateSignature other) {
        this.successors = new ResizingArrayStorage<State>(other.successors);
        this.acceptance = other.acceptance;
        this.updateHashCode();
    }

    void updateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.acceptance.hashCode();
        this.hashCode = result = 31 * result + Arrays.hashCode(this.successors.array);
    }

    StateSignature duplicate() {
        return new StateSignature(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateSignature)) {
            return false;
        }
        StateSignature other = (StateSignature)obj;
        return this.hashCode == other.hashCode && this.acceptance == other.acceptance && Arrays.equals(this.successors.array, other.successors.array);
    }
}

