/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.tree;

import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.incremental.dfa.Acceptance;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Node {
    private Acceptance acceptance;
    private @Nullable ResizingArrayStorage<Node> children;

    Node() {
        this(Acceptance.DONT_KNOW);
    }

    Node(Acceptance acceptance) {
        this.acceptance = acceptance;
    }

    Acceptance getAcceptance() {
        return this.acceptance;
    }

    void setAcceptance(Acceptance acceptance) {
        this.acceptance = acceptance;
    }

    @Nullable Node getChild(int idx) {
        if (this.children == null) {
            return null;
        }
        return ((Node[])this.children.array)[idx];
    }

    void setChild(int idx, int alphabetSize, Node child) {
        if (this.children == null) {
            this.children = new ResizingArrayStorage<Node>(Node.class, alphabetSize);
        }
        ((Node[])this.children.array)[idx] = child;
    }

    void makeSink() {
        this.children = null;
        this.acceptance = Acceptance.FALSE;
    }

    void ensureInputCapacity(int capacity) {
        if (this.children != null) {
            this.children.ensureCapacity(capacity);
        }
    }
}

