/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.moore;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.incremental.IncrementalConstruction;
import net.automatalib.ts.output.MooreTransitionSystem;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public interface IncrementalMooreBuilder<I, O>
extends IncrementalConstruction<MooreMachine<?, I, ?, O>, I>,
SupportsGrowingAlphabet<I> {
    public boolean lookup(Word<? extends I> var1, List<? super O> var2);

    default public Word<O> lookup(Word<? extends I> inputWord) {
        WordBuilder wb = new WordBuilder(inputWord.size() + 1);
        this.lookup(inputWord, wb);
        return wb.toWord();
    }

    @Override
    default public boolean hasDefinitiveInformation(Word<? extends I> word) {
        return this.lookup(word, new ArrayList(word.length() + 1));
    }

    public void insert(Word<? extends I> var1, Word<? extends O> var2);

    public MooreTransitionSystem<?, I, ?, O> asTransitionSystem();
}

