/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.solver.M3CSolver;
import net.automatalib.modelchecker.m3c.solver.StringADDSolver;
import net.automatalib.modelchecker.m3c.solver.StringBDDSolver;
import net.automatalib.modelchecker.m3c.solver.TypedADDSolver;
import net.automatalib.modelchecker.m3c.solver.TypedBDDSolver;

public final class M3CSolvers {
    private M3CSolvers() {
    }

    public static M3CSolver<String> solver(ContextFreeModalProcessSystem<String, String> cfmps) {
        return M3CSolvers.bddSolver(cfmps);
    }

    public static <L, AP> M3CSolver.TypedM3CSolver<FormulaNode<L, AP>> typedSolver(ContextFreeModalProcessSystem<L, AP> cfmps) {
        return M3CSolvers.typedBDDSolver(cfmps);
    }

    public static M3CSolver<String> addSolver(ContextFreeModalProcessSystem<String, String> cfmps) {
        return new StringADDSolver(cfmps);
    }

    public static <L, AP> M3CSolver.TypedM3CSolver<FormulaNode<L, AP>> typedADDSolver(ContextFreeModalProcessSystem<L, AP> cfmps) {
        return new TypedADDSolver<L, AP>(cfmps);
    }

    public static M3CSolver<String> bddSolver(ContextFreeModalProcessSystem<String, String> cfmps) {
        return new StringBDDSolver(cfmps);
    }

    public static <L, AP> M3CSolver.TypedM3CSolver<FormulaNode<L, AP>> typedBDDSolver(ContextFreeModalProcessSystem<L, AP> cfmps) {
        return new TypedBDDSolver<L, AP>(cfmps);
    }
}

