/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.transformer;

import info.scce.addlib.dd.xdd.latticedd.example.BooleanVector;
import java.util.Set;
import java.util.function.BinaryOperator;
import net.automatalib.modelchecker.m3c.formula.AbstractBinaryFormulaNode;
import net.automatalib.modelchecker.m3c.formula.AndNode;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.EquationalBlock;
import net.automatalib.modelchecker.m3c.formula.FalseNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.NotNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;

public class DiamondOperation<AP>
implements BinaryOperator<BooleanVector> {
    private final EquationalBlock<?, AP> block;
    private final Set<AP> atomicPropositions;

    public DiamondOperation(Set<AP> atomicPropositions, EquationalBlock<?, AP> block) {
        this.atomicPropositions = atomicPropositions;
        this.block = block;
    }

    @Override
    public BooleanVector apply(BooleanVector left, BooleanVector right) {
        boolean[] result = (boolean[])left.data().clone();
        for (FormulaNode<?, AP> node : this.block.getNodes()) {
            int currentVar = node.getVarNumber();
            if (node instanceof BoxNode) {
                result[currentVar] = result[currentVar] && right.data()[currentVar];
                continue;
            }
            if (node instanceof DiamondNode) {
                result[currentVar] = result[currentVar] || right.data()[currentVar];
                continue;
            }
            if (node instanceof AbstractBinaryFormulaNode) {
                AbstractBinaryFormulaNode binaryNode = (AbstractBinaryFormulaNode)node;
                int xj1 = binaryNode.getVarNumberLeft();
                int xj2 = binaryNode.getVarNumberRight();
                if (binaryNode instanceof AndNode) {
                    result[currentVar] = result[xj1] && result[xj2];
                    continue;
                }
                result[currentVar] = result[xj1] || result[xj2];
                continue;
            }
            if (node instanceof TrueNode) {
                result[currentVar] = true;
                continue;
            }
            if (node instanceof FalseNode) {
                result[currentVar] = false;
                continue;
            }
            if (node instanceof NotNode) {
                NotNode notNode = (NotNode)node;
                result[currentVar] = !result[notNode.getVarNumberChild()];
                continue;
            }
            if (node instanceof AtomicNode) {
                Object prop = ((AtomicNode)node).getProposition();
                result[currentVar] = this.atomicPropositions.contains(prop);
                continue;
            }
            throw new IllegalArgumentException("The current equational block contains an unsupported formula type.");
        }
        return new BooleanVector(result);
    }
}

