/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecking;

import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelChecker;

public interface ModelCheckerLasso<I, A, P, R extends Lasso<I, ?>>
extends ModelChecker<I, A, P, R> {
    public double getMultiplier();

    public void setMultiplier(double var1);

    public int getMinimumUnfolds();

    public void setMinimumUnfolds(int var1);

    default public int computeUnfolds(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal size: " + size);
        }
        int relativeUnfolds = (int)Math.ceil((double)size * this.getMultiplier());
        return Math.max(this.getMinimumUnfolds(), relativeUnfolds);
    }

    public static interface MealyModelCheckerLasso<I, O, P>
    extends ModelCheckerLasso<I, MealyMachine<?, I, ?, O>, P, Lasso.MealyLasso<I, O>>,
    ModelChecker.MealyModelChecker<I, O, P, Lasso.MealyLasso<I, O>> {
    }

    public static interface DFAModelCheckerLasso<I, P>
    extends ModelCheckerLasso<I, DFA<?, I>, P, Lasso.DFALasso<I>>,
    ModelChecker.DFAModelChecker<I, P, Lasso.DFALasso<I>> {
    }
}

