/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.serialization.saf.SAFInput;
import net.automatalib.serialization.saf.SAFOutput;

public final class SAFSerializationDFA
implements InputModelSerializationProvider<Integer, DFA<?, Integer>, DFA<Integer, Integer>> {
    private static final SAFSerializationDFA INSTANCE = new SAFSerializationDFA();

    private SAFSerializationDFA() {
    }

    public static SAFSerializationDFA getInstance() {
        return INSTANCE;
    }

    @Override
    public InputModelData<Integer, DFA<Integer, Integer>> readModel(InputStream is) throws IOException {
        try (InputStream stream = IOUtil.asUncompressedBufferedNonClosingInputStream(is);){
            SAFInput in = new SAFInput(stream);
            CompactDFA<Integer> automaton = in.readNativeDFA();
            InputModelData<Integer, DFA<Integer, Integer>> inputModelData = new InputModelData<Integer, DFA<Integer, Integer>>(automaton, automaton.getInputAlphabet());
            return inputModelData;
        }
    }

    @Override
    public void writeModel(OutputStream os, DFA<?, Integer> model, Alphabet<Integer> alphabet) throws IOException {
        SAFOutput out = new SAFOutput(os);
        out.writeDFA(model, alphabet);
    }
}

