/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.writer;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.string.StringUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TAFWriter {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private final Appendable out;
    private int indent;

    private TAFWriter(Appendable out) {
        this.out = out;
    }

    public static <I> void writeAny(FiniteAlphabetAutomaton<?, I, ?> automaton, Appendable out) throws IOException {
        TAFWriter.writeAny(automaton, automaton.getInputAlphabet(), out);
    }

    public static <I> void writeAny(Automaton<?, I, ?> automaton, Collection<? extends I> inputs, Appendable out) throws IOException {
        if (automaton instanceof DFA) {
            TAFWriter.writeDFA((DFA)automaton, inputs, out);
        } else if (automaton instanceof MealyMachine) {
            TAFWriter.writeMealy((MealyMachine)automaton, inputs, out);
        } else {
            throw new IllegalArgumentException("Unknown type " + automaton.getClass().getSimpleName());
        }
    }

    public static <I> void dfaToString(DFA<?, I> dfa, Collection<? extends I> inputs) {
        try {
            StringBuilder sb = new StringBuilder();
            TAFWriter.writeDFA(dfa, inputs, sb);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static <S, I> void writeDFA(DFA<S, I> dfa, Collection<? extends I> inputs, Appendable out) throws IOException {
        TAFWriter writer = new TAFWriter(out);
        writer.doWriteAutomaton(dfa, inputs, "dfa", s2 -> dfa.isAccepting(s2) ? Collections.singleton("accepting") : Collections.emptySet());
    }

    public static <I> void writeDFA(DFA<?, I> dfa, Collection<? extends I> inputs, File out) throws IOException {
        try (Writer bw = IOUtil.asBufferedUTF8Writer(out);){
            TAFWriter.writeDFA(dfa, inputs, bw);
        }
    }

    private <S, I, T, TP> void doWriteAutomaton(UniversalDeterministicAutomaton<S, I, T, ?, TP> automaton, Collection<? extends I> inputs, String type, Function<S, ? extends Collection<? extends String>> spExtractor) throws IOException {
        this.begin(type, inputs);
        Object init = automaton.getInitialState();
        StateIDs<Object> ids = automaton.stateIDs();
        for (Object state : automaton) {
            HashSet<String> options = new HashSet<String>(spExtractor.apply(state));
            if (Objects.equals(init, state)) {
                options.add("initial");
            }
            int id = ids.getStateId(state);
            String name = "s" + id;
            this.beginState(name, options);
            HashMap<Pair, List> groupedTransitions = Maps.newHashMapWithExpectedSize(inputs.size());
            for (I i : inputs) {
                Object t = automaton.getTransition(state, i);
                if (t == null) continue;
                Object succ = automaton.getSuccessor(t);
                Object tp = automaton.getTransitionProperty(t);
                Pair key = Pair.of(succ, tp);
                groupedTransitions.computeIfAbsent(key, k -> new ArrayList()).add(i);
            }
            for (Map.Entry entry : groupedTransitions.entrySet()) {
                Object tgt = ((Pair)entry.getKey()).getFirst();
                int tgtId = ids.getStateId(tgt);
                String tgtName = "s" + tgtId;
                Object transProp = ((Pair)entry.getKey()).getSecond();
                this.writeTransition((Collection)entry.getValue(), tgtName, transProp);
            }
            this.endState();
        }
        this.end();
    }

    private void begin(String type, Collection<?> inputs) throws IOException {
        this.writeIndent();
        this.out.append(type).append(' ');
        this.writeStringCollection(inputs);
        this.out.append(" {").append(System.lineSeparator());
        ++this.indent;
    }

    private void beginState(String name, Set<String> options) throws IOException {
        this.writeIndent();
        this.out.append(name).append(' ');
        if (!options.isEmpty()) {
            this.out.append(options.toString()).append(' ');
        }
        this.out.append('{').append(System.lineSeparator());
        ++this.indent;
    }

    private void writeTransition(Collection<?> symbols, String target, @Nullable Object output) throws IOException {
        this.writeIndent();
        this.writeStringCollection(symbols);
        if (output != null) {
            this.out.append(" / ").append(StringUtil.enquoteIfNecessary(output.toString()));
        }
        this.out.append(" -> ").append(target).append(System.lineSeparator());
    }

    private void endState() throws IOException {
        --this.indent;
        this.writeIndent();
        this.out.append('}').append(System.lineSeparator());
    }

    private void end() throws IOException {
        --this.indent;
        this.writeIndent();
        this.out.append('}').append(System.lineSeparator());
    }

    private void writeIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.append('\t');
        }
    }

    private void writeStringCollection(Collection<?> symbols) throws IOException {
        if (symbols.isEmpty()) {
            this.out.append("{}");
        } else if (symbols.size() == 1) {
            Object sym = symbols.iterator().next();
            StringUtil.enquoteIfNecessary(String.valueOf(sym), this.out, ID_PATTERN);
        } else {
            this.out.append('{');
            boolean first = true;
            for (Object sym : symbols) {
                if (first) {
                    first = false;
                } else {
                    this.out.append(',');
                }
                StringUtil.enquoteIfNecessary(String.valueOf(sym), this.out, ID_PATTERN);
            }
            this.out.append('}');
        }
    }

    public static <I> void writeMealy(MealyMachine<?, I, ?, ?> mealy, Collection<? extends I> inputs, File out) throws IOException {
        try (Writer bw = IOUtil.asBufferedUTF8Writer(out);){
            TAFWriter.writeMealy(mealy, inputs, bw);
        }
    }

    public static <I> void writeMealy(MealyMachine<?, I, ?, ?> mealy, Collection<? extends I> inputs, Appendable out) throws IOException {
        TAFWriter writer = new TAFWriter(out);
        writer.doWriteAutomaton(mealy, inputs, "mealy", s2 -> Collections.emptySet());
    }

    public static <I> void mealyToString(MealyMachine<?, I, ?, ?> mealy, Collection<? extends I> inputs) {
        try {
            StringBuilder sb = new StringBuilder();
            TAFWriter.writeMealy(mealy, inputs, sb);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

