/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.simple.SimpleDTS;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DeterministicTransitionSystem<S, I, T>
extends TransitionSystem<S, I, T>,
SimpleDTS<S, I> {
    @Override
    default public @Nullable S getSuccessor(S state, I input) {
        T trans = this.getTransition(state, input);
        if (trans == null) {
            return null;
        }
        return this.getSuccessor(trans);
    }

    public @Nullable T getTransition(S var1, I var2);

    @Override
    default public Set<S> getSuccessors(S state, I input) {
        return SimpleDTS.super.getSuccessors(state, input);
    }

    @Override
    default public Collection<T> getTransitions(S state, I input) {
        return DeterministicTransitionSystem.transToSet(this.getTransition(state, input));
    }

    public static <T> Set<T> transToSet(@Nullable T trans) {
        if (trans == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(trans);
    }
}

