/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.automaton.MutableAutomaton;

class AutomatonBuilderImpl<S, I, T, SP, TP, A extends MutableAutomaton<S, ? super I, T, ? super SP, ? super TP>> {
    protected final A automaton;
    private final Map<Object, S> stateMap = new HashMap<Object, S>();
    protected List<S> currentStates;
    protected List<I> currentInputs;
    protected TP currentTransProp;

    AutomatonBuilderImpl(A automaton) {
        this.automaton = automaton;
    }

    public void from(Object stateId) {
        this.currentStates = this.getStates(stateId, new Object[0]);
        this.currentInputs = null;
    }

    public void from(Object firstStateId, Object ... otherStateIds) {
        this.currentStates = this.getStates(firstStateId, otherStateIds);
    }

    protected List<S> getStates(Object firstStateId, Object ... otherStateIds) {
        if (otherStateIds.length == 0) {
            return Collections.singletonList(this.getState(firstStateId));
        }
        ArrayList<S> result = new ArrayList<S>(1 + otherStateIds.length);
        result.add(this.getState(firstStateId));
        for (Object otherId : otherStateIds) {
            result.add(this.getState(otherId));
        }
        return result;
    }

    protected S getState(Object stateId) {
        if (this.stateMap.containsKey(stateId)) {
            return this.stateMap.get(stateId);
        }
        Object state = this.automaton.addState();
        this.stateMap.put(stateId, state);
        return state;
    }

    public void on(I input) {
        this.currentInputs = Collections.singletonList(input);
        this.currentTransProp = null;
    }

    @SafeVarargs
    public final void on(I firstInput, I ... otherInputs) {
        this.currentInputs = new ArrayList<I>(1 + otherInputs.length);
        this.currentInputs.add(firstInput);
        Collections.addAll(this.currentInputs, otherInputs);
        this.currentTransProp = null;
    }

    public void withProperty(TP transProp) {
        this.currentTransProp = transProp;
    }

    public void to(Object stateId) {
        S tgt = this.getState(stateId);
        for (S src : this.currentStates) {
            for (I input : this.currentInputs) {
                this.automaton.addTransition(src, input, tgt, this.currentTransProp);
            }
        }
    }

    public void loop() {
        for (S src : this.currentStates) {
            for (I input : this.currentInputs) {
                this.automaton.addTransition(src, input, src, this.currentTransProp);
            }
        }
    }

    public A create() {
        return this.automaton;
    }

    public void withInitial(Object stateId) {
        S state = this.getState(stateId);
        this.automaton.setInitial(state, true);
    }

    public void withStateProperty(SP stateProperty, Object stateId) {
        S state = this.getState(stateId);
        this.automaton.setStateProperty(state, stateProperty);
    }
}

