/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.conformance;

import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.common.util.collection.AbstractThreeLevelIterator;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.util.automaton.equivalence.CharacterizingSets;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WpMethodTestsIterator<I>
extends ForwardingIterator<Word<I>> {
    private final Iterator<Word<I>> wpIterator;

    public WpMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs) {
        this(automaton, inputs, 0);
    }

    public WpMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, int maxDepth) {
        HashSet stateCover = Sets.newHashSetWithExpectedSize(automaton.size());
        HashSet transitionCover = Sets.newHashSetWithExpectedSize(automaton.size() * inputs.size());
        Covers.cover(automaton, inputs, stateCover, transitionCover);
        Iterator characterizingIter = CharacterizingSets.characterizingSetIterator(automaton, inputs);
        if (!characterizingIter.hasNext()) {
            characterizingIter = Iterators.singletonIterator(Word.epsilon());
        }
        FirstPhaseIterator firstIterator = new FirstPhaseIterator(stateCover, CollectionsUtil.allTuples(inputs, 0, maxDepth), characterizingIter);
        transitionCover.removeAll(stateCover);
        SecondPhaseIterator secondIterator = new SecondPhaseIterator(automaton, inputs, transitionCover, CollectionsUtil.allTuples(inputs, 0, maxDepth));
        this.wpIterator = Iterators.concat(firstIterator, secondIterator);
    }

    @Override
    protected Iterator<Word<I>> delegate() {
        return this.wpIterator;
    }

    private static class SecondPhaseIterator<S, I>
    extends AbstractThreeLevelIterator<Word<I>, List<I>, Word<I>, Word<I>> {
        private final UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton;
        private final Collection<? extends I> inputs;
        private final MutableMapping<S, @Nullable List<Word<I>>> localSuffixSets;
        private final Iterable<List<I>> middleParts;

        SecondPhaseIterator(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Iterable<Word<I>> prefixes, Iterable<List<I>> middleParts) {
            super(prefixes.iterator());
            this.automaton = automaton;
            this.inputs = inputs;
            this.localSuffixSets = automaton.createStaticStateMapping();
            this.middleParts = middleParts;
        }

        @Override
        protected Iterator<List<I>> l2Iterator(Word<I> prefix) {
            return this.middleParts.iterator();
        }

        @Override
        protected Iterator<Word<I>> l3Iterator(Word<I> prefix, List<I> middle) {
            @NonNull S tmp = this.automaton.getState(prefix);
            @NonNull S state = this.automaton.getSuccessor(tmp, middle);
            @Nullable List<Word<I>> localSuffixes = (List<Word<I>>)this.localSuffixSets.get(state);
            if (localSuffixes == null) {
                localSuffixes = Automata.stateCharacterizingSet(this.automaton, this.inputs, state);
                if (localSuffixes.isEmpty()) {
                    localSuffixes = Collections.singletonList(Word.epsilon());
                }
                this.localSuffixSets.put(state, localSuffixes);
            }
            return localSuffixes.iterator();
        }

        @Override
        protected Word<I> combine(Word<I> prefix, List<I> middle, Word<I> suffix) {
            WordBuilder<I> wb = new WordBuilder<I>(prefix.size() + middle.size() + suffix.size());
            return wb.append(prefix).append(middle).append(suffix).toWord();
        }
    }

    private static class FirstPhaseIterator<I>
    extends AbstractThreeLevelIterator<Word<I>, List<I>, Word<I>, Word<I>> {
        private final Iterable<Word<I>> prefixes;
        private final Iterable<List<I>> middleParts;

        FirstPhaseIterator(Iterable<Word<I>> prefixes, Iterable<List<I>> middleParts, Iterator<Word<I>> suffixes) {
            super(suffixes);
            this.prefixes = prefixes;
            this.middleParts = middleParts;
        }

        @Override
        protected Iterator<List<I>> l2Iterator(Word<I> suffix) {
            return this.middleParts.iterator();
        }

        @Override
        protected Iterator<Word<I>> l3Iterator(Word<I> suffix, List<I> middle) {
            return this.prefixes.iterator();
        }

        @Override
        protected Word<I> combine(Word<I> suffix, List<I> middle, Word<I> prefix) {
            WordBuilder<I> wb = new WordBuilder<I>(prefix.size() + middle.size() + suffix.size());
            return wb.append(prefix).append(middle).append(suffix).toWord();
        }
    }
}

