/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.IndefiniteGraph;
import net.automatalib.util.traversal.VisitedState;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BreadthFirstIterator<N, E>
implements Iterator<N> {
    private final Queue<N> bfsQueue = new ArrayDeque<N>();
    private final MutableMapping<N, @Nullable VisitedState> visited;
    private final IndefiniteGraph<N, E> graph;

    BreadthFirstIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        this.graph = graph;
        this.visited = graph.createStaticNodeMapping();
        this.bfsQueue.addAll(start);
        for (N node : start) {
            this.visited.put(node, VisitedState.VISITED);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.bfsQueue.isEmpty();
    }

    @Override
    public N next() {
        N result = this.bfsQueue.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        Iterator<E> edgeIter = this.graph.getOutgoingEdgesIterator(result);
        while (edgeIter.hasNext()) {
            E edge = edgeIter.next();
            N tgt = this.graph.getTarget(edge);
            if (this.visited.put(tgt, VisitedState.VISITED) == VisitedState.VISITED) continue;
            this.bfsQueue.add(tgt);
        }
        return result;
    }
}

