/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph.traversal;

import java.util.Iterator;
import net.automatalib.graph.IndefiniteGraph;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleDFRecord<N, E> {
    final N node;
    private @Nullable Iterator<E> edgeIterator;

    SimpleDFRecord(N node) {
        this.node = node;
    }

    boolean wasStarted() {
        return this.edgeIterator != null;
    }

    boolean start(IndefiniteGraph<N, E> graph) {
        if (this.edgeIterator != null) {
            return false;
        }
        this.edgeIterator = graph.getOutgoingEdgesIterator(this.node);
        return true;
    }

    boolean hasNextEdge() {
        if (this.edgeIterator == null) {
            throw new IllegalStateException("Edge iteration not yet started");
        }
        return this.edgeIterator.hasNext();
    }

    E nextEdge() {
        if (this.edgeIterator == null) {
            throw new IllegalStateException("Edge iteration not yet started");
        }
        return this.edgeIterator.next();
    }
}

