/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.modal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.common.util.Holder;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.fixpoint.WorksetMappingAlgorithm;
import net.automatalib.ts.modal.ModalTransitionSystem;
import net.automatalib.ts.modal.MutableModalTransitionSystem;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import net.automatalib.ts.modal.transition.MutableModalEdgeProperty;
import net.automatalib.util.ts.modal.IllegalConjunctionException;
import net.automatalib.util.ts.traversal.TSTraversal;
import net.automatalib.util.ts.traversal.TSTraversalAction;
import net.automatalib.util.ts.traversal.TSTraversalVisitor;

class ModalConjunction<A extends MutableModalTransitionSystem<S, I, T, ?>, S, S0, S1, I, T, T0, T1, TP0 extends ModalEdgeProperty, TP1 extends ModalEdgeProperty>
implements WorksetMappingAlgorithm<Pair<S0, S1>, S, A> {
    private static final float LOAD_FACTOR = 0.5f;
    private final ModalTransitionSystem<S0, I, T0, TP0> mts0;
    private final ModalTransitionSystem<S1, I, T1, TP1> mts1;
    private final A result;

    ModalConjunction(ModalTransitionSystem<S0, I, T0, TP0> mts0, ModalTransitionSystem<S1, I, T1, TP1> mts1, AutomatonCreator<A, I> creator) {
        if (!mts0.getInputAlphabet().equals(mts1.getInputAlphabet())) {
            throw new IllegalArgumentException("Conjunction MTSs must have the same input alphabet");
        }
        this.mts0 = mts0;
        this.mts1 = mts1;
        this.result = (MutableModalTransitionSystem)creator.createAutomaton(mts0.getInputAlphabet());
    }

    @Override
    public int expectedElementCount() {
        return (int)(0.5f * (float)this.mts0.size() * (float)this.mts1.size());
    }

    @Override
    public Collection<Pair<S0, S1>> initialize(Map<Pair<S0, S1>, S> mapping) {
        ArrayList<Pair<S0, S1>> initialElements = new ArrayList<Pair<S0, S1>>(this.mts0.getInitialStates().size() * this.mts1.getInitialStates().size());
        for (Object s0 : this.mts0.getInitialStates()) {
            for (Object s1 : this.mts1.getInitialStates()) {
                Pair init = Pair.of(s0, s1);
                Object newState = this.result.addInitialState();
                mapping.put(init, newState);
                initialElements.add(init);
            }
        }
        return initialElements;
    }

    @Override
    public Collection<Pair<S0, S1>> update(Map<Pair<S0, S1>, S> mapping, Pair<S0, S1> currentStatePair) {
        Collection transitions1;
        Collection transitions0;
        S mappedState = mapping.get(currentStatePair);
        assert (mappedState != null);
        ArrayList<Pair<S0, S1>> discovered = new ArrayList<Pair<S0, S1>>();
        for (Object sym : this.mts0.getInputAlphabet()) {
            transitions0 = this.mts0.getTransitions(currentStatePair.getFirst(), sym);
            transitions1 = this.mts1.getInputAlphabet().containsSymbol(sym) ? this.mts1.getTransitions(currentStatePair.getSecond(), sym) : Collections.emptySet();
            for (Object transition0 : transitions0) {
                if (((ModalEdgeProperty)this.mts0.getTransitionProperty(transition0)).isMust() && transitions1.isEmpty()) {
                    throw new IllegalConjunctionException(String.format("Error in conjunction: States <%s,%s> for label=%s with outgoing transitions t0=%s, t1=%s. Error for transition %s (t0), leading trace: %s", currentStatePair.getFirst(), currentStatePair.getSecond(), sym, transitions0, transitions1, transition0, ModalConjunction.traceError(this.mts0, transition0)));
                }
                for (Object transition1 : transitions1) {
                    Pair newTuple = Pair.of(this.mts0.getSuccessor(transition0), this.mts1.getSuccessor(transition1));
                    S newState = mapping.get(newTuple);
                    if (newState == null) {
                        newState = this.result.addState();
                        mapping.put(newTuple, newState);
                        discovered.add(newTuple);
                    }
                    Object newT = this.result.createTransition(newState);
                    this.result.addTransition(mappedState, sym, newT);
                    if (((ModalEdgeProperty)this.mts0.getTransitionProperty(transition0)).isMust() || ((ModalEdgeProperty)this.mts1.getTransitionProperty(transition1)).isMust()) {
                        ((MutableModalEdgeProperty)this.result.getTransitionProperty(newT)).setMust();
                        continue;
                    }
                    ((MutableModalEdgeProperty)this.result.getTransitionProperty(newT)).setMayOnly();
                }
            }
        }
        for (Object sym : this.mts1.getInputAlphabet()) {
            transitions0 = this.mts0.getInputAlphabet().containsSymbol(sym) ? this.mts0.getTransitions(currentStatePair.getFirst(), sym) : Collections.emptySet();
            transitions1 = this.mts1.getTransitions(currentStatePair.getSecond(), sym);
            for (Object transition1 : transitions1) {
                if (!((ModalEdgeProperty)this.mts1.getTransitionProperty(transition1)).isMust() || !transitions0.isEmpty()) continue;
                throw new IllegalConjunctionException(String.format("Error in conjunction: States <%s,%s> for label=%s with outgoing transitions t0=%s, t1=%s. Error for transition %s (t1), leading trace: %s", currentStatePair.getFirst(), currentStatePair.getSecond(), sym, transitions0, transitions1, transition1, ModalConjunction.traceError(this.mts1, transition1)));
            }
        }
        return discovered;
    }

    @Override
    public A result() {
        return this.result;
    }

    private static <S, I, T, TP extends ModalEdgeProperty> String traceError(ModalTransitionSystem<S, I, T, TP> mts, T transition) {
        EdgeTracer finder = new EdgeTracer(transition);
        TSTraversal.depthFirst(mts, mts.getInputAlphabet(), finder);
        StringJoiner sj = new StringJoiner(", ");
        for (Object state : finder.getStateSequence()) {
            sj.add(Objects.toString(state));
        }
        return sj.toString();
    }

    private static class EdgeTracer<S, I, T>
    implements TSTraversalVisitor<S, I, T, Void> {
        private final Set<S> stateStack;
        private final T targetTransition;

        EdgeTracer(T transition) {
            this.targetTransition = transition;
            this.stateStack = new LinkedHashSet<S>();
        }

        @Override
        public boolean startExploration(S state, Void data) {
            this.stateStack.add(state);
            return true;
        }

        @Override
        public void finishExploration(S state, Void data) {
            this.stateStack.remove(state);
        }

        @Override
        public TSTraversalAction processTransition(S srcState, Void srcData, I input, T transition, S tgtState, Holder<Void> tgtHolder) {
            boolean modified = this.stateStack.add(tgtState);
            if (transition == this.targetTransition) {
                return TSTraversalAction.ABORT_TRAVERSAL;
            }
            if (!modified) {
                return TSTraversalAction.IGNORE;
            }
            return TSTraversalAction.EXPLORE;
        }

        @Override
        public void backtrackTransition(S srcState, Void srcData, I input, T transition, S tgtState, Void tgtData) {
            this.stateStack.remove(tgtState);
        }

        Iterable<S> getStateSequence() {
            return this.stateStack;
        }
    }
}

