/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.aaar.abstraction;

import de.learnlib.algorithm.aaar.Abstraction;
import de.learnlib.algorithm.aaar.abstraction.Node;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.automatalib.graph.Graph;
import net.automatalib.graph.concept.GraphViewable;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;

public abstract class AbstractAbstractionTree<AI, CI, D>
implements Abstraction<AI, CI>,
GraphViewable,
Graph<Node, Node> {
    private Node root;
    private final MembershipOracle<CI, D> oracle;
    private final Map<AI, CI> gamma;

    public AbstractAbstractionTree(AI rootA, CI rootC, MembershipOracle<CI, D> o) {
        this.root = new Node.Leaf<AI, CI>(rootA, rootC);
        this.oracle = o;
        this.gamma = new HashMap<AI, CI>();
        this.gamma.put(rootA, rootC);
    }

    public AI splitLeaf(CI repOld, CI repNew, Word<CI> prefix, Word<CI> suffix, D outOld) {
        Node.Leaf<AI, CI> l = new Node.Leaf<AI, CI>(this.createAbstractionForRepresentative(repNew), repNew);
        this.gamma.put(l.abs, repNew);
        Node cur = this.root;
        Node parent = null;
        while (cur instanceof Node.InnerNode) {
            Node.InnerNode n = (Node.InnerNode)cur;
            Word test = n.prefix.append(repOld).concat(n.suffix);
            D out = this.oracle.answerQuery(test);
            parent = cur;
            if (Objects.equals(n.out, out)) {
                cur = n.equalsNext;
                continue;
            }
            cur = n.otherNext;
        }
        Node.InnerNode<CI, D> newNode = new Node.InnerNode<CI, D>(prefix, suffix, outOld, cur, l);
        if (parent == null) {
            this.root = newNode;
        } else {
            Node.InnerNode parentAsInner = (Node.InnerNode)parent;
            if (parentAsInner.equalsNext == cur) {
                parentAsInner.equalsNext = newNode;
            } else {
                parentAsInner.otherNext = newNode;
            }
        }
        return l.abs;
    }

    @Override
    public AI getAbstractSymbol(CI c) {
        Node cur = this.root;
        while (cur instanceof Node.InnerNode) {
            Node.InnerNode n = (Node.InnerNode)cur;
            Word test = n.prefix.append(c).concat(n.suffix);
            D out = this.oracle.answerQuery(test);
            if (Objects.equals(n.out, out)) {
                cur = n.equalsNext;
                continue;
            }
            cur = n.otherNext;
        }
        Node.Leaf leaf = (Node.Leaf)cur;
        return leaf.abs;
    }

    @Override
    public CI getRepresentative(AI a) {
        CI ci = this.gamma.get(a);
        assert (ci != null);
        return ci;
    }

    public Collection<CI> getRepresentativeSymbols() {
        return Collections.unmodifiableCollection(this.gamma.values());
    }

    @Override
    public Graph<?, ?> graphView() {
        return this;
    }

    @Override
    public Collection<Node> getOutgoingEdges(Node node) {
        if (node instanceof Node.InnerNode) {
            Node.InnerNode n = (Node.InnerNode)node;
            return Arrays.asList(n.equalsNext, n.otherNext);
        }
        return Collections.emptySet();
    }

    @Override
    public Node getTarget(Node edge) {
        return edge;
    }

    @Override
    public Collection<Node> getNodes() {
        ArrayList<Node> result = new ArrayList<Node>(this.gamma.size());
        ArrayDeque<Node> nodes = new ArrayDeque<Node>();
        nodes.add(this.root);
        while (!nodes.isEmpty()) {
            Node n = (Node)nodes.poll();
            if (n instanceof Node.InnerNode) {
                Node.InnerNode in = (Node.InnerNode)n;
                result.add(in);
                nodes.add(in.equalsNext);
                nodes.add(in.otherNext);
                continue;
            }
            assert (n != null);
            result.add(n);
        }
        return result;
    }

    @Override
    public VisualizationHelper<Node, Node> getVisualizationHelper() {
        return new DefaultVisualizationHelper<Node, Node>(){

            @Override
            public boolean getNodeProperties(Node node, Map<String, String> properties) {
                super.getNodeProperties(node, properties);
                if (node instanceof Node.InnerNode) {
                    Node.InnerNode n = (Node.InnerNode)node;
                    properties.put("label", n.prefix + ", " + n.suffix);
                } else if (node instanceof Node.Leaf) {
                    Node.Leaf l = (Node.Leaf)node;
                    properties.put("label", String.format("Abs.: '%s'%nRep.: '%s'", l.abs, l.rep));
                }
                return true;
            }

            @Override
            public boolean getEdgeProperties(Node src, Node edge, Node tgt, Map<String, String> properties) {
                super.getEdgeProperties(src, edge, tgt, properties);
                if (src instanceof Node.InnerNode) {
                    Node.InnerNode n = (Node.InnerNode)src;
                    if (n.equalsNext == tgt) {
                        properties.put("label", "== " + n.out);
                    } else {
                        properties.put("label", "!= " + n.out);
                        properties.put("style", "dashed");
                    }
                }
                return true;
            }
        };
    }

    protected abstract AI createAbstractionForRepresentative(CI var1);
}

