/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.config.model.replacer;

import de.learnlib.algorithm.adt.adt.ADT;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.SubtreeReplacer;
import de.learnlib.algorithm.adt.config.model.ADSCalculator;
import de.learnlib.algorithm.adt.config.model.replacer.SingleReplacer;
import de.learnlib.algorithm.adt.model.ReplacementResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;

public class LevelOrderReplacer
implements SubtreeReplacer {
    private final ADSCalculator adsCalculator;

    public LevelOrderReplacer(ADSCalculator adsProvider) {
        this.adsCalculator = adsProvider;
    }

    @Override
    public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
        if (ADTUtil.collectResetNodes(adt.getRoot()).isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ReplacementResult<S, I, O>> result = new LinkedHashSet<ReplacementResult<S, I, O>>();
        LinkedList queue = new LinkedList();
        queue.add(adt.getRoot());
        while (!queue.isEmpty()) {
            ReplacementResult<S, I, O> replacementResult;
            ADTNode node = (ADTNode)queue.poll();
            Set targetStates = ADTUtil.collectHypothesisStates(node);
            if (!adt.getRoot().equals(node) && (replacementResult = SingleReplacer.computeParentExtension(hypothesis, inputs, node, targetStates, this.adsCalculator)) != null) {
                result.add(replacementResult);
                continue;
            }
            if (ADTUtil.collectResetNodes(node).isEmpty()) continue;
            Optional<ADTNode<S, I, O>> potentialADS = this.adsCalculator.compute(hypothesis, inputs, targetStates);
            if (potentialADS.isPresent()) {
                result.add(new ReplacementResult<S, I, O>(node, potentialADS.get()));
                continue;
            }
            queue.addAll(ADTUtil.collectDirectSubADSs(node));
        }
        return result;
    }
}

