/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.learner;

import de.learnlib.Resumable;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.adt.adt.ADT;
import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.adt.ADTResetNode;
import de.learnlib.algorithm.adt.api.ADTExtender;
import de.learnlib.algorithm.adt.api.LeafSplitter;
import de.learnlib.algorithm.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithm.adt.api.SubtreeReplacer;
import de.learnlib.algorithm.adt.automaton.ADTHypothesis;
import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.algorithm.adt.automaton.ADTTransition;
import de.learnlib.algorithm.adt.config.ADTExtenders;
import de.learnlib.algorithm.adt.config.LeafSplitters;
import de.learnlib.algorithm.adt.config.SubtreeReplacers;
import de.learnlib.algorithm.adt.learner.ADTLearnerState;
import de.learnlib.algorithm.adt.model.ExtensionResult;
import de.learnlib.algorithm.adt.model.ObservationTree;
import de.learnlib.algorithm.adt.model.ReplacementResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import de.learnlib.algorithm.adt.util.SQOOTBridge;
import de.learnlib.counterexample.LocalSuffixFinders;
import de.learnlib.logging.Category;
import de.learnlib.oracle.SymbolQueryOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.ads.RecursiveADSNode;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADTLearner<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
PartialTransitionAnalyzer<ADTState<I, O>, I>,
SupportsGrowingAlphabet<I>,
Resumable<ADTLearnerState<ADTState<I, O>, I, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ADTLearner.class);
    private final Alphabet<I> alphabet;
    private final SQOOTBridge<I, O> oracle;
    private final LeafSplitter leafSplitter;
    private final ADTExtender adtExtender;
    private final SubtreeReplacer subtreeReplacer;
    private final Queue<ADTTransition<I, O>> openTransitions;
    private final Queue<DefaultQuery<I, Word<O>>> openCounterExamples;
    private final Set<DefaultQuery<I, Word<O>>> allCounterExamples;
    private final ObservationTree<ADTState<I, O>, I, O> observationTree;
    private ADTHypothesis<I, O> hypothesis;
    private ADT<ADTState<I, O>, I, O> adt;

    public ADTLearner(Alphabet<I> alphabet, SymbolQueryOracle<I, O> oracle, LeafSplitter leafSplitter, ADTExtender adtExtender, SubtreeReplacer subtreeReplacer) {
        this(alphabet, oracle, leafSplitter, adtExtender, subtreeReplacer, true);
    }

    public ADTLearner(Alphabet<I> alphabet, SymbolQueryOracle<I, O> oracle, LeafSplitter leafSplitter, ADTExtender adtExtender, SubtreeReplacer subtreeReplacer, boolean useObservationTree) {
        this.alphabet = alphabet;
        this.observationTree = new ObservationTree(this.alphabet);
        this.oracle = new SQOOTBridge<I, O>(this.observationTree, oracle, useObservationTree);
        this.leafSplitter = leafSplitter;
        this.adtExtender = adtExtender;
        this.subtreeReplacer = subtreeReplacer;
        this.hypothesis = new ADTHypothesis(this.alphabet);
        this.openTransitions = new ArrayDeque<ADTTransition<I, O>>();
        this.openCounterExamples = new ArrayDeque<DefaultQuery<I, Word<O>>>();
        this.allCounterExamples = new LinkedHashSet<DefaultQuery<I, Word<O>>>();
        this.adt = new ADT();
    }

    @Override
    public void startLearning() {
        ADTState initialState = (ADTState)this.hypothesis.addInitialState();
        initialState.setAccessSequence(Word.epsilon());
        this.observationTree.initialize(initialState);
        this.oracle.initialize();
        this.adt.initialize(initialState);
        for (Object i : this.alphabet) {
            this.openTransitions.add(this.hypothesis.createOpenTransition(initialState, i, this.adt.getRoot()));
        }
        this.closeTransitions();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ce) {
        if (!MQUtil.isCounterexample(ce, this.hypothesis)) {
            return false;
        }
        this.evaluateSubtreeReplacement();
        this.openCounterExamples.add(ce);
        while (!this.openCounterExamples.isEmpty()) {
            while (!this.openCounterExamples.isEmpty()) {
                DefaultQuery<I, Word<O>> currentCE = this.openCounterExamples.poll();
                this.allCounterExamples.add(currentCE);
                while (this.refineHypothesisInternal(currentCE)) {
                }
            }
            for (DefaultQuery<I, Word<O>> oldCE : this.allCounterExamples) {
                if (((Word)this.hypothesis.computeOutput(oldCE.getInput())).equals(oldCE.getOutput())) continue;
                this.openCounterExamples.add(oldCE);
            }
            ADTUtil.collectLeaves(this.adt.getRoot()).forEach(this::ensureConsistency);
        }
        return true;
    }

    public boolean refineHypothesisInternal(DefaultQuery<I, Word<O>> ceQuery) {
        ADTNode<ADTState<I, O>, I, O> newNode;
        if (!MQUtil.isCounterexample(ceQuery, this.hypothesis)) {
            return false;
        }
        int suffixIdx = LocalSuffixFinders.RIVEST_SCHAPIRE.findSuffixIndex(ceQuery, this.hypothesis, this.hypothesis, this.oracle);
        if (suffixIdx == -1) {
            throw new IllegalStateException();
        }
        Word ceInput = ceQuery.getInput();
        Word u = ceInput.prefix(suffixIdx - 1);
        Word ua = ceInput.prefix(suffixIdx);
        Object a = ceInput.getSymbol(suffixIdx - 1);
        Word v = ceInput.subWord(suffixIdx);
        ADTState uState = (ADTState)this.hypothesis.getState(u);
        ADTState uaState = (ADTState)this.hypothesis.getState(ua);
        assert (uState != null && uaState != null);
        Word uAccessSequence = uState.getAccessSequence();
        Word uaAccessSequence = uaState.getAccessSequence();
        Word uAccessSequenceWithA = uAccessSequence.append(a);
        ADTState newState = (ADTState)this.hypothesis.addState();
        newState.setAccessSequence(uAccessSequenceWithA);
        ADTTransition oldTrans = (ADTTransition)this.hypothesis.getTransition(uState, a);
        assert (oldTrans != null);
        oldTrans.setTarget(newState);
        oldTrans.setIsSpanningTreeEdge(true);
        Set<ADTNode<ADTState<I, O>, I, O>> finalNodes = ADTUtil.collectLeaves(this.adt.getRoot());
        ADTNode nodeToSplit = finalNodes.stream().filter(n -> uaState.equals(n.getHypothesisState())).findFirst().orElseThrow(IllegalStateException::new);
        this.observationTree.addState(newState, newState.getAccessSequence(), oldTrans.getOutput());
        this.observationTree.addTrace(newState, nodeToSplit);
        Word previousTrace = ADTUtil.buildTraceForNode(nodeToSplit).getFirst();
        Optional<Word<I>> extension = this.observationTree.findSeparatingWord(uaState, newState, previousTrace);
        if (extension.isPresent()) {
            Word completeSplitter = previousTrace.concat(extension.get());
            Word<O> oldOutput = this.observationTree.trace(uaState, completeSplitter);
            Word<O> newOutput = this.observationTree.trace(newState, completeSplitter);
            newNode = this.adt.extendLeaf(nodeToSplit, completeSplitter, oldOutput, newOutput, this.leafSplitter);
        } else {
            this.observationTree.addTrace(uaState, v, (Word)this.oracle.answerQuery(uaAccessSequence, v));
            this.observationTree.addTrace(newState, v, (Word)this.oracle.answerQuery(uAccessSequenceWithA, v));
            Word<I> otSepWord = this.observationTree.findSeparatingWord(uaState, newState);
            Word<I> splitter = otSepWord.length() < v.length() ? otSepWord : v;
            Word<O> oldOutput = this.observationTree.trace(uaState, splitter);
            Word<O> newOutput = this.observationTree.trace(newState, splitter);
            newNode = this.adt.splitLeaf(nodeToSplit, splitter, oldOutput, newOutput, this.leafSplitter);
        }
        newNode.setHypothesisState(newState);
        ADTNode temporarySplitter = ADTUtil.getStartOfADS(nodeToSplit);
        List newTransitions = this.alphabet.stream().map(i -> this.hypothesis.createOpenTransition(newState, i, this.adt.getRoot())).collect(Collectors.toList());
        List<ADTTransition> transitionsToRefine = ((ADTState)nodeToSplit.getHypothesisState()).getIncomingTransitions().stream().filter(x -> !x.isSpanningTreeEdge()).collect(Collectors.toList());
        transitionsToRefine.forEach(x -> {
            x.setTarget(null);
            x.setSiftNode(temporarySplitter);
        });
        ADTNode finalizedSplitter = this.evaluateAdtExtension(temporarySplitter);
        transitionsToRefine.stream().filter(ADTTransition::needsSifting).forEach(x -> {
            x.setSiftNode(finalizedSplitter);
            this.openTransitions.add((ADTTransition<I, O>)x);
        });
        newTransitions.stream().filter(ADTTransition::needsSifting).forEach(this.openTransitions::add);
        this.closeTransitions();
        return true;
    }

    @Override
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    private void closeTransitions() {
        while (!this.openTransitions.isEmpty()) {
            this.closeTransition(this.openTransitions.poll());
        }
    }

    private void closeTransition(ADTTransition<I, O> transition) {
        ADTState targetState;
        if (!transition.needsSifting()) {
            return;
        }
        Word<I> accessSequence = transition.getSource().getAccessSequence();
        I symbol = transition.getInput();
        this.oracle.reset();
        for (I i : accessSequence) {
            this.oracle.query(i);
        }
        transition.setOutput(this.oracle.query(symbol));
        Word<I> longPrefix = accessSequence.append(symbol);
        ADTNode<ADTState<I, O>, I, O> finalNode = this.adt.sift(this.oracle, longPrefix, transition.getSiftNode());
        assert (ADTUtil.isLeafNode(finalNode));
        if (finalNode.getHypothesisState() == null) {
            targetState = (ADTState)this.hypothesis.addState();
            targetState.setAccessSequence(longPrefix);
            finalNode.setHypothesisState(targetState);
            transition.setIsSpanningTreeEdge(true);
            this.observationTree.addState(targetState, longPrefix, transition.getOutput());
            for (Object i : this.alphabet) {
                this.openTransitions.add(this.hypothesis.createOpenTransition(targetState, i, this.adt.getRoot()));
            }
        } else {
            targetState = (ADTState)finalNode.getHypothesisState();
        }
        transition.setTarget(targetState);
    }

    @Override
    public void closeTransition(ADTState<I, O> state, I input) {
        ADTTransition transition = (ADTTransition)this.hypothesis.getTransition(state, input);
        assert (transition != null);
        if (transition.needsSifting()) {
            ADTNode ads = transition.getSiftNode();
            int oldNumberOfFinalStates = ADTUtil.collectLeaves(ads).size();
            this.closeTransition(transition);
            int newNumberOfFinalStates = ADTUtil.collectLeaves(ads).size();
            if (oldNumberOfFinalStates < newNumberOfFinalStates) {
                throw PartialTransitionAnalyzer.HYPOTHESIS_MODIFICATION_EXCEPTION;
            }
        }
    }

    @Override
    public boolean isTransitionDefined(ADTState<I, O> state, I input) {
        ADTTransition transition = (ADTTransition)this.hypothesis.getTransition(state, input);
        assert (transition != null);
        return !transition.needsSifting();
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        this.observationTree.getObservationTree().addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor((ADTState)this.hypothesis.getInitialState(), symbol) == null) {
            for (ADTState s2 : this.hypothesis.getStates()) {
                this.openTransitions.add(this.hypothesis.createOpenTransition(s2, symbol, this.adt.getRoot()));
            }
            this.closeTransitions();
        }
    }

    @Override
    public ADTLearnerState<ADTState<I, O>, I, O> suspend() {
        return new ADTLearnerState<ADTState<I, O>, I, O>(this.hypothesis, this.adt);
    }

    @Override
    public void resume(ADTLearnerState<ADTState<I, O>, I, O> state) {
        this.hypothesis = state.getHypothesis();
        this.adt = state.getAdt();
        Alphabet oldAlphabet = this.hypothesis.getInputAlphabet();
        if (!oldAlphabet.equals(this.alphabet)) {
            LOGGER.warn(Category.DATASTRUCTURE, "The current alphabet '{}' differs from the resumed alphabet '{}'. Future behavior may be inconsistent", (Object)this.alphabet, (Object)oldAlphabet);
        }
        if (this.hypothesis.size() > 0) {
            this.observationTree.initialize(this.hypothesis.getStates(), ADTState::getAccessSequence, this.hypothesis::computeOutput);
            this.oracle.initialize();
        }
    }

    private void ensureConsistency(ADTNode<ADTState<I, O>, I, O> leaf) {
        ADTState state = (ADTState)leaf.getHypothesisState();
        Word as = state.getAccessSequence();
        Word asOut = (Word)this.hypothesis.computeOutput(as);
        ADTNode iter = leaf;
        while (iter != null) {
            Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(iter);
            Word<I> input = trace.getFirst();
            Word<O> output = trace.getSecond();
            Object hypOut = this.hypothesis.computeStateOutput(state, (Iterable)input);
            if (!((Word)hypOut).equals(output)) {
                this.openCounterExamples.add(new DefaultQuery(as.concat(input), asOut.concat(output)));
            }
            iter = (ADTNode)ADTUtil.getStartOfADS(iter).getParent();
        }
    }

    private ADTNode<ADTState<I, O>, I, O> evaluateAdtExtension(ADTNode<ADTState<I, O>, I, O> ads) {
        ExtensionResult<ADTState<I, O>, I, O> potentialExtension = this.adtExtender.computeExtension(this.hypothesis, this, ads);
        if (potentialExtension.isCounterExample()) {
            this.openCounterExamples.add(potentialExtension.getCounterExample());
            return ads;
        }
        if (!potentialExtension.isReplacement()) {
            return ads;
        }
        ADTNode<ADTState<I, O>, I, O> extension = potentialExtension.getReplacement();
        ADTNode nodeToReplace = (ADTNode)ads.getParent();
        assert (this.validateADS(nodeToReplace, extension, Collections.emptySet()));
        ADTNode<ADTState<I, O>, I, O> replacement = this.verifyADS(nodeToReplace, extension, ADTUtil.collectLeaves(this.adt.getRoot()), Collections.emptySet());
        int oldCosts = ADTUtil.computeEffectiveResets(nodeToReplace);
        int newCosts = ADTUtil.computeEffectiveResets(replacement);
        if (newCosts >= oldCosts) {
            return ads;
        }
        this.adt.replaceNode(nodeToReplace, replacement);
        ADTNode<ADTState<I, O>, I, O> finalizedADS = ADTUtil.getStartOfADS(replacement);
        this.resiftAffectedTransitions(ADTUtil.collectLeaves(extension), finalizedADS);
        return finalizedADS;
    }

    private void evaluateSubtreeReplacement() {
        ADTNode<ADTState<I, O>, I, O> nodeToReplace;
        if (this.hypothesis.size() == 1) {
            return;
        }
        Set<ReplacementResult<ADTState<I, O>, I, O>> potentialReplacements = this.subtreeReplacer.computeReplacements(this.hypothesis, this.alphabet, this.adt);
        ArrayList<ReplacementResult<ADTState<I, O>, I, O>> validReplacements = new ArrayList<ReplacementResult<ADTState<I, O>, I, O>>(potentialReplacements.size());
        Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves = potentialReplacements.isEmpty() ? Collections.emptySet() : ADTUtil.collectLeaves(this.adt.getRoot());
        for (ReplacementResult<ADTState<I, O>, I, O> potentialReplacement : potentialReplacements) {
            ADTNode<ADTState<I, O>, I, O> proposedReplacement = potentialReplacement.getReplacement();
            nodeToReplace = potentialReplacement.getNodeToReplace();
            assert (this.validateADS(nodeToReplace, proposedReplacement, potentialReplacement.getCutoutNodes()));
            ADTNode<ADTState<I, O>, I, O> replacement = this.verifyADS(nodeToReplace, proposedReplacement, cachedLeaves, potentialReplacement.getCutoutNodes());
            int oldCosts = ADTUtil.computeEffectiveResets(nodeToReplace);
            int newCosts = ADTUtil.computeEffectiveResets(replacement);
            if (newCosts >= oldCosts) continue;
            validReplacements.add(new ReplacementResult<ADTState<I, O>, I, O>(nodeToReplace, replacement));
        }
        for (ReplacementResult<ADTState<I, O>, I, O> potentialReplacement : validReplacements) {
            ADTNode<ADTState<I, O>, I, O> replacement = potentialReplacement.getReplacement();
            nodeToReplace = potentialReplacement.getNodeToReplace();
            this.adt.replaceNode(nodeToReplace, replacement);
            this.resiftAffectedTransitions(ADTUtil.collectLeaves(replacement), ADTUtil.getStartOfADS(replacement));
        }
        this.closeTransitions();
    }

    private boolean validateADS(ADTNode<ADTState<I, O>, I, O> oldADS, ADTNode<ADTState<I, O>, I, O> newADS, Set<ADTState<I, O>> cutout) {
        Set<ADTNode<ADTState<I, O>, I, O>> oldNodes = ADTUtil.isResetNode(oldADS) ? ADTUtil.collectResetNodes(this.adt.getRoot()) : ADTUtil.collectADSNodes(this.adt.getRoot());
        if (!oldNodes.contains(oldADS)) {
            throw new IllegalArgumentException("Subtree to replace does not exist");
        }
        Set<ADTNode<ADTState<I, O>, I, O>> newFinalNodes = ADTUtil.collectLeaves(newADS);
        Set<ADTState<I, O>> oldFinalStates = ADTUtil.collectHypothesisStates(oldADS);
        Set newFinalStates = newFinalNodes.stream().map(RecursiveADSNode::getHypothesisState).collect(Collectors.toSet());
        newFinalStates.addAll(cutout);
        if (!oldFinalStates.equals(newFinalStates)) {
            throw new IllegalArgumentException("New ADS does not cover all old nodes");
        }
        Word<I> parentInputTrace = ADTUtil.buildTraceForNode(oldADS).getFirst();
        Map<ADTState, Pair> traces = newFinalNodes.stream().collect(Collectors.toMap(RecursiveADSNode::getHypothesisState, ADTUtil::buildTraceForNode));
        for (Map.Entry<ADTState, Pair> entry : traces.entrySet()) {
            Word accessSequence = entry.getKey().getAccessSequence();
            Word prefix = accessSequence.concat(parentInputTrace);
            Word input = (Word)entry.getValue().getFirst();
            Word output = (Word)entry.getValue().getSecond();
            if (((Word)this.hypothesis.computeSuffixOutput(prefix, input)).equals(output)) continue;
            throw new IllegalArgumentException("Output of new ADS does not match hypothesis");
        }
        return true;
    }

    private ADTNode<ADTState<I, O>, I, O> verifyADS(ADTNode<ADTState<I, O>, I, O> nodeToReplace, ADTNode<ADTState<I, O>, I, O> replacement, Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves, Set<ADTState<I, O>> cutout) {
        LinkedHashMap traces = new LinkedHashMap();
        ADTUtil.collectLeaves(replacement).forEach(x -> traces.put((ADTState)x.getHypothesisState(), ADTUtil.buildTraceForNode(x)));
        Pair<Word<I>, Word<O>> parentTrace = ADTUtil.buildTraceForNode(nodeToReplace);
        Word<I> parentInput = parentTrace.getFirst();
        Word<O> parentOutput = parentTrace.getSecond();
        ADTNode result = null;
        for (Map.Entry entry : traces.entrySet()) {
            ADTState state = (ADTState)entry.getKey();
            Word accessSequence = state.getAccessSequence();
            this.oracle.reset();
            accessSequence.forEach(this.oracle::query);
            parentInput.forEach(this.oracle::query);
            Word adsInput = (Word)((Pair)entry.getValue()).getFirst();
            Word adsOutput = (Word)((Pair)entry.getValue()).getSecond();
            WordBuilder inputWb = new WordBuilder(adsInput.size());
            WordBuilder<O> outputWb = new WordBuilder<O>(adsInput.size());
            Iterator inputIter = adsInput.iterator();
            Iterator outputIter = adsOutput.iterator();
            boolean equal = true;
            while (equal && inputIter.hasNext()) {
                Object in = inputIter.next();
                O realOut = this.oracle.query(in);
                Object expectedOut = outputIter.next();
                inputWb.append(in);
                outputWb.append(realOut);
                if (expectedOut.equals(realOut)) continue;
                equal = false;
            }
            Word traceInput = inputWb.toWord();
            Word traceOutput = outputWb.toWord();
            if (!equal) {
                this.openCounterExamples.add(new DefaultQuery(accessSequence.concat(parentInput, traceInput), ((Word)this.hypothesis.computeOutput(state.getAccessSequence())).concat(parentOutput, traceOutput)));
            }
            ADTNode trace = ADTUtil.buildADSFromObservation(traceInput, traceOutput, state);
            if (result == null) {
                result = trace;
                continue;
            }
            if (ADTUtil.mergeADS(result, trace)) continue;
            this.resolveAmbiguities(nodeToReplace, result, state, cachedLeaves);
        }
        for (ADTState aDTState : cutout) {
            this.resolveAmbiguities(nodeToReplace, result, aDTState, cachedLeaves);
        }
        return result;
    }

    private void resolveAmbiguities(ADTNode<ADTState<I, O>, I, O> nodeToReplace, ADTNode<ADTState<I, O>, I, O> newADS, ADTState<I, O> state, Set<ADTNode<ADTState<I, O>, I, O>> cachedLeaves) {
        ADTNode newTrace;
        Pair<Word<I>, Word<O>> parentTrace = ADTUtil.buildTraceForNode(nodeToReplace);
        Word<I> parentInput = parentTrace.getFirst();
        Word<I> effectiveAccessSequence = state.getAccessSequence().concat(parentInput);
        this.oracle.reset();
        effectiveAccessSequence.forEach(this.oracle::query);
        ADTNode iter = newADS;
        while (!ADTUtil.isLeafNode(iter)) {
            if (ADTUtil.isResetNode(iter)) {
                this.oracle.reset();
                state.getAccessSequence().forEach(this.oracle::query);
                iter = (ADTNode)iter.getChildren().values().iterator().next();
                continue;
            }
            O output = this.oracle.query(iter.getSymbol());
            ADTNode succ = (ADTNode)iter.getChildren().get(output);
            if (succ == null) {
                ADTLeafNode newFinal = new ADTLeafNode(iter, state);
                iter.getChildren().put(output, newFinal);
                return;
            }
            iter = succ;
        }
        ADTNode<ADTState<I, O>, I, O> oldReference = null;
        ADTNode<ADTState<I, O>, I, O> newReference = null;
        for (ADTNode<ADTState<I, O>, I, O> leaf : cachedLeaves) {
            ADTState hypState = (ADTState)leaf.getHypothesisState();
            assert (hypState != null);
            if (hypState.equals(iter.getHypothesisState())) {
                oldReference = leaf;
            } else if (hypState.equals(state)) {
                newReference = leaf;
            }
            if (oldReference == null || newReference == null) continue;
            break;
        }
        ADT.LCAInfo<ADTState<I, O>, I, O> lcaResult = this.adt.findLCA(oldReference, newReference);
        ADTNode lca = lcaResult.adtNode;
        Pair lcaTrace = ADTUtil.buildTraceForNode(lca);
        Word sepWord = lcaTrace.getFirst().append(lca.getSymbol());
        Word oldOutputTrace = lcaTrace.getSecond().append(lcaResult.firstOutput);
        Word newOutputTrace = lcaTrace.getSecond().append(lcaResult.secondOutput);
        ADTNode oldTrace = ADTUtil.buildADSFromObservation(sepWord, oldOutputTrace, (ADTState)iter.getHypothesisState());
        if (!ADTUtil.mergeADS(oldTrace, newTrace = ADTUtil.buildADSFromObservation(sepWord, newOutputTrace, state))) {
            throw new IllegalStateException("Should never happen");
        }
        ADTResetNode reset = new ADTResetNode(oldTrace);
        ADTNode parent = (ADTNode)iter.getParent();
        assert (parent != null);
        Object parentOutput = ADTUtil.getOutputForSuccessor(parent, iter);
        parent.getChildren().put(parentOutput, reset);
        reset.setParent(parent);
        oldTrace.setParent(reset);
    }

    private void resiftAffectedTransitions(Set<ADTNode<ADTState<I, O>, I, O>> states, ADTNode<ADTState<I, O>, I, O> finalizedADS) {
        for (ADTNode<ADTState<I, O>, I, O> state : states) {
            List transitionsToRefine = ((ADTState)state.getHypothesisState()).getIncomingTransitions().stream().filter(x -> !x.isSpanningTreeEdge()).collect(Collectors.toList());
            for (ADTTransition trans : transitionsToRefine) {
                trans.setTarget(null);
                trans.setSiftNode(finalizedADS);
                this.openTransitions.add(trans);
            }
        }
    }

    public ADT<ADTState<I, O>, I, O> getADT() {
        return this.adt;
    }

    static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static LeafSplitter leafSplitter() {
            return LeafSplitters.DEFAULT_SPLITTER;
        }

        public static ADTExtender adtExtender() {
            return ADTExtenders.EXTEND_BEST_EFFORT;
        }

        public static SubtreeReplacer subtreeReplacer() {
            return SubtreeReplacers.LEVELED_BEST_EFFORT;
        }

        public static boolean useObservationTree() {
            return true;
        }
    }
}

