/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.util;

import de.learnlib.algorithm.adt.model.ObservationTree;
import de.learnlib.oracle.SymbolQueryOracle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.automaton.transducer.FastMealy;
import net.automatalib.automaton.transducer.FastMealyState;

public class SQOOTBridge<I, O>
implements SymbolQueryOracle<I, O> {
    private final FastMealy<I, O> observationTree;
    private final SymbolQueryOracle<I, O> delegate;
    private final boolean enableCache;
    private final List<I> currentTrace;
    private FastMealyState<O> currentState;
    private boolean currentTraceValid;

    public SQOOTBridge(ObservationTree<?, I, O> observationTree, SymbolQueryOracle<I, O> delegate, boolean enableCache) {
        this.observationTree = observationTree.getObservationTree();
        this.delegate = delegate;
        this.enableCache = enableCache;
        this.currentTrace = enableCache ? new ArrayList() : Collections.emptyList();
    }

    public void initialize() {
        this.currentState = (FastMealyState)this.observationTree.getInitialState();
        this.currentTraceValid = this.enableCache;
    }

    @Override
    public O query(I i) {
        FastMealyState nextState;
        if (this.currentTraceValid) {
            FastMealyState<O> succ = this.observationTree.getSuccessor(this.currentState, i);
            if (succ != null) {
                Object output = this.observationTree.getOutput(this.currentState, i);
                this.currentTrace.add(i);
                this.currentState = succ;
                return output;
            }
            this.currentTraceValid = false;
            this.delegate.reset();
            for (I trace : this.currentTrace) {
                this.delegate.query(trace);
            }
        }
        O output = this.delegate.query(i);
        FastMealyState succ = this.observationTree.getSuccessor(this.currentState, i);
        if (succ == null) {
            FastMealyState newState;
            nextState = newState = (FastMealyState)this.observationTree.addState();
            if (this.enableCache) {
                this.observationTree.addTransition(this.currentState, i, newState, output);
            }
        } else {
            assert (Objects.equals(output, this.observationTree.getOutput(this.currentState, i))) : "Inconsistent observations";
            nextState = succ;
        }
        this.currentState = nextState;
        return output;
    }

    @Override
    public void reset() {
        this.currentState = (FastMealyState)this.observationTree.getInitialState();
        if (this.enableCache) {
            this.currentTrace.clear();
            this.currentTraceValid = true;
        } else {
            this.delegate.reset();
        }
    }
}

