/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.kv;

import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StateInfo<I, D> {
    public final int id;
    public final Word<I> accessSequence;
    public AbstractWordBasedDTNode<I, D, StateInfo<I, D>> dtNode;
    private @Nullable List<Long> incoming;

    public StateInfo(int id, Word<I> accessSequence) {
        this.accessSequence = accessSequence.trimmed();
        this.id = id;
    }

    public void addIncoming(int sourceState, int transIdx) {
        long encodedTrans = (long)sourceState << 32 | (long)transIdx;
        if (this.incoming == null) {
            this.incoming = new ArrayList<Long>();
        }
        this.incoming.add(encodedTrans);
    }

    public List<Long> fetchIncoming() {
        if (this.incoming == null || this.incoming.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> result = this.incoming;
        this.incoming = null;
        return result;
    }
}

