/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lstar.mealy;

import de.learnlib.algorithm.lstar.AbstractExtensibleAutomatonLStar;
import de.learnlib.algorithm.lstar.ce.ObservationTableCEXHandler;
import de.learnlib.algorithm.lstar.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithm.lstar.closing.ClosingStrategies;
import de.learnlib.algorithm.lstar.closing.ClosingStrategy;
import de.learnlib.algorithm.lstar.mealy.LStarMealyUtil;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collections;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.CompactTransition;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

public class ClassicLStarMealy<I, O>
extends AbstractExtensibleAutomatonLStar<MealyMachine<?, I, ?, O>, I, O, Integer, CompactTransition<O>, Void, O, CompactMealy<I, O>> {
    private final O emptyOutput;

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle) {
        this(alphabet, oracle, ObservationTableCEXHandlers.CLASSIC_LSTAR, ClosingStrategies.CLOSE_FIRST);
    }

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        this(alphabet, oracle, Collections.singletonList(Word.epsilon()), Collections.emptyList(), cexHandler, closingStrategy);
    }

    public ClassicLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super O> cexHandler, ClosingStrategy<? super I, ? super O> closingStrategy) {
        super(alphabet, oracle, new CompactMealy(alphabet), initialPrefixes, LStarMealyUtil.ensureSuffixCompliancy(initialSuffixes, alphabet, true), cexHandler, closingStrategy);
        this.emptyOutput = oracle.answerQuery(Word.epsilon());
    }

    @Override
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return (MealyMachine)((Object)this.internalHyp);
    }

    @Override
    protected Void stateProperty(ObservationTable<I, O> table, Row<I> stateRow) {
        return null;
    }

    @Override
    protected O transitionProperty(ObservationTable<I, O> table, Row<I> stateRow, int inputIdx) {
        return table.cellContents(stateRow, inputIdx);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        throw new UnsupportedOperationException("This implementation does not correct support adding new alphabet symbols. Use the ExtensibleLStarMealy implementation with the classic counterexample handler instead.");
    }

    @Override
    protected SuffixOutput<I, O> hypothesisOutput() {
        return (prefix, suffix) -> {
            Word wordOut = (Word)((CompactMealy)this.internalHyp).computeSuffixOutput(prefix, suffix);
            return wordOut.isEmpty() ? this.emptyOutput : wordOut.lastSymbol();
        };
    }
}

