/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.observationpack.vpa.hypothesis;

import de.learnlib.AccessSequenceProvider;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.AbstractHypTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.DTNode;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypIntTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypRetTrans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.common.smartcollection.ArrayStorage;
import net.automatalib.word.Word;

public class HypLoc<I>
implements AccessSequenceProvider<I> {
    private final AbstractHypTrans<I> treeIncoming;
    private final Word<I> aseq;
    private final ArrayStorage<HypIntTrans<I>> intSuccessors;
    private final ArrayStorage<List<HypRetTrans<I>>> returnSuccessors;
    private final int index;
    private boolean accepting;
    private DTNode<I> leaf;

    public HypLoc(VPAlphabet<I> alphabet, int index, boolean accepting, AbstractHypTrans<I> treeIncoming) {
        this.index = index;
        this.accepting = accepting;
        this.intSuccessors = new ArrayStorage(alphabet.getNumInternals());
        this.returnSuccessors = new ArrayStorage<List>(alphabet.getNumReturns(), ArrayList::new);
        this.treeIncoming = treeIncoming;
        this.aseq = treeIncoming != null ? treeIncoming.getAccessSequence() : Word.epsilon();
    }

    public void updateStackAlphabetSize(int newStackAlphaSize) {
        for (int i = 0; i < this.returnSuccessors.size(); ++i) {
            List<HypRetTrans<I>> transList = this.returnSuccessors.get(i);
            if (transList == null) {
                transList = new ArrayList<Object>(Collections.nCopies(newStackAlphaSize, null));
                this.returnSuccessors.set(i, transList);
                continue;
            }
            if (transList.size() >= newStackAlphaSize) continue;
            transList.addAll(Collections.nCopies(newStackAlphaSize - transList.size(), null));
        }
    }

    public DTNode<I> getLeaf() {
        return this.leaf;
    }

    public void setLeaf(DTNode<I> leaf) {
        this.leaf = leaf;
    }

    public boolean isRoot() {
        return this.treeIncoming == null;
    }

    @Override
    public Word<I> getAccessSequence() {
        return this.aseq;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public void setAccepting(boolean accepting) {
        this.accepting = accepting;
    }

    public HypRetTrans<I> getReturnTransition(int retSymId, int stackSym) {
        List<HypRetTrans<I>> succList = this.returnSuccessors.get(retSymId);
        return succList.get(stackSym);
    }

    public void setReturnTransition(int retSymId, int stackSym, HypRetTrans<I> trans) {
        int numSuccs;
        List<HypRetTrans<I>> succList = this.returnSuccessors.get(retSymId);
        if (succList == null) {
            succList = new ArrayList<HypRetTrans<I>>(stackSym + 1);
            this.returnSuccessors.set(retSymId, succList);
        }
        if ((numSuccs = succList.size()) <= stackSym) {
            succList.addAll(Collections.nCopies(stackSym + 1 - numSuccs, null));
        }
        succList.set(stackSym, trans);
    }

    public HypIntTrans<I> getInternalTransition(int intSymId) {
        return this.intSuccessors.get(intSymId);
    }

    public void setInternalTransition(int intSymId, HypIntTrans<I> succ) {
        this.intSuccessors.set(intSymId, succ);
    }

    public String toString() {
        return Integer.toString(this.index);
    }
}

