/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.oml.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.algorithm.oml.ttt.pt.PTNode;
import de.learnlib.algorithm.oml.ttt.pt.PrefixTree;
import de.learnlib.algorithm.oml.ttt.st.SuffixTrie;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.word.Word;

public abstract class AbstractOptimalTTT<M, I, D>
implements LearningAlgorithm<M, I, D>,
SupportsGrowingAlphabet<I>,
InputAlphabetHolder<I> {
    private final MembershipOracle<I, D> ceqs;
    private final Alphabet<I> alphabet;
    protected final SuffixTrie<I> strie;
    protected final PrefixTree<I, D> ptree;

    protected AbstractOptimalTTT(Alphabet<I> alphabet, MembershipOracle<I, D> ceqs) {
        this.alphabet = alphabet;
        this.ceqs = ceqs;
        this.strie = new SuffixTrie();
        this.ptree = new PrefixTree();
    }

    protected abstract int maxSearchIndex(int var1);

    protected abstract D hypOutput(Word<I> var1, int var2);

    protected abstract DTLeaf<I, D> getState(Word<I> var1);

    protected abstract AbstractDecisionTree<I, D> dtree();

    protected abstract D suffix(D var1, int var2);

    protected abstract boolean isCanonical();

    @Override
    public void startLearning() {
        assert (this.dtree() != null && this.getHypothesisModel() != null);
        this.dtree().sift(this.ptree.root());
        this.makeConsistent();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, D> counterexample) {
        LinkedHashSet<DefaultQuery<I, D>> witnesses = new LinkedHashSet<DefaultQuery<I, D>>();
        witnesses.add(counterexample);
        boolean refined = this.refineWithWitness(counterexample, witnesses);
        if (!refined) {
            return false;
        }
        if (this.isCanonical()) {
            return true;
        }
        do {
            DefaultQuery w;
            Iterator iterator = witnesses.iterator();
            while (iterator.hasNext() && !(refined = this.refineWithWitness(w = (DefaultQuery)iterator.next(), witnesses))) {
            }
        } while (refined && this.isCanonical());
        return true;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        if (this.ptree.root().succ(symbol) == null) {
            List<DTLeaf<I, D>> leaves = this.dtree().leaves();
            for (DTLeaf<I, D> leaf : leaves) {
                PTNode<I, D> u = leaf.getShortPrefixes().get(0);
                assert (u != null);
                PTNode<I, D> ua = u.append(symbol);
                assert (ua != null);
                this.dtree().sift(ua);
            }
            this.makeConsistent();
        }
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    private boolean refineWithWitness(DefaultQuery<I, D> counterexample, Set<DefaultQuery<I, D>> witnesses) {
        D hypOut;
        if (counterexample.getOutput() == null) {
            counterexample.answer(this.ceqs.answerQuery(counterexample.getInput()));
        }
        if (Objects.equals(hypOut = this.hypOutput(counterexample.getInput(), counterexample.getSuffix().length()), counterexample.getOutput())) {
            return false;
        }
        do {
            this.analyzeCounterexample(counterexample.getInput(), witnesses);
            this.makeConsistent();
        } while (!Objects.equals(hypOut = this.hypOutput(counterexample.getInput(), counterexample.getSuffix().length()), counterexample.getOutput()));
        return true;
    }

    private void makeConsistent() {
        while (this.dtree().makeConsistent()) {
        }
    }

    private PTNode<I, D> longestShortPrefixOf(Word<I> ce) {
        PTNode<I, D> cur = this.ptree.root();
        int i = 0;
        do {
            cur = cur.succ(ce.getSymbol(i++));
            assert (cur != null);
        } while (cur.state().getShortPrefixes().contains(cur) && i < ce.length());
        assert (!cur.state().getShortPrefixes().contains(cur));
        return cur;
    }

    private void analyzeCounterexample(Word<I> ce, Set<DefaultQuery<I, D>> witnesses) {
        int mid;
        PTNode<I, D> ua = null;
        PTNode<I, D> lsp = this.longestShortPrefixOf(ce);
        int upper = this.maxSearchIndex(ce.length());
        int lower = lsp.word().length() - 1;
        D hypOut = this.hypOutput(ce, ce.length());
        while (upper - lower > 1) {
            mid = (upper + lower) / 2;
            Word<I> prefix = ce.prefix(mid);
            Word<I> suffix = ce.suffix(ce.length() - mid);
            DTLeaf<I, D> q = this.getState(prefix);
            assert (q != null);
            boolean stillCe = false;
            for (PTNode<I, D> u : q.getShortPrefixes()) {
                D sysOut = this.suffix(this.ceqs.answerQuery(u.word(), suffix), suffix.size());
                if (Objects.equals(sysOut, this.suffix(hypOut, suffix.size()))) continue;
                ua = u.succ(suffix.firstSymbol());
                lower = mid;
                stillCe = true;
                break;
            }
            if (stillCe) continue;
            upper = mid;
        }
        if (ua == null) {
            assert (lower == lsp.word().length() - 1);
            ua = lsp;
        }
        mid = (upper + lower) / 2;
        Word<I> sprime = ce.suffix(ce.length() - (mid + 1));
        DTLeaf<I, D> qnext = this.getState(ua.word());
        for (PTNode<I, D> uprime : qnext.getShortPrefixes()) {
            witnesses.add(new DefaultQuery<I, Word<I>>(uprime.word(), sprime));
        }
        witnesses.add(new DefaultQuery<I, Word<I>>(ua.word(), sprime));
        ua.makeShortPrefix();
    }
}

