/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.mealy;

import de.learnlib.algorithm.oml.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.oml.ttt.dt.Children;
import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.algorithm.oml.ttt.mealy.ChildrenMealy;
import de.learnlib.algorithm.oml.ttt.pt.PTNode;
import de.learnlib.algorithm.oml.ttt.st.STNode;
import de.learnlib.oracle.MembershipOracle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;

class DecisionTreeMealy<I, O>
extends AbstractDecisionTree<I, Word<O>> {
    private final Map<Word<I>, Word<O>> outputs = new HashMap<Word<I>, Word<O>>();

    DecisionTreeMealy(MembershipOracle<I, Word<O>> mqOracle, Alphabet<I> sigma, STNode<I> stRoot) {
        super(sigma, mqOracle, stRoot);
    }

    @Override
    protected Children<I, Word<O>> newChildren() {
        return new ChildrenMealy();
    }

    @Override
    protected Word<O> query(PTNode<I, Word<O>> prefix, STNode<I> suffix) {
        return ((Word)this.mqOracle.answerQuery(prefix.word(), suffix.word())).suffix(suffix.word().length());
    }

    Word<O> getOutput(DTLeaf<I, Word<O>> leaf, I a) {
        return this.lookupOrQuery(leaf.getShortPrefixes().get(0).word(), Word.fromLetter(a));
    }

    @Override
    public boolean makeConsistent() {
        for (DTLeaf dTLeaf : this.leaves()) {
            if (dTLeaf.getShortPrefixes().size() < 2) continue;
            for (Object a : this.alphabet) {
                Word<O> refOut = null;
                LinkedList sp = new LinkedList(dTLeaf.getShortPrefixes());
                for (PTNode pTNode : sp) {
                    Word<O> out = this.lookupOrQuery(pTNode.word(), Word.fromLetter(a));
                    if (refOut == null) {
                        refOut = out;
                        continue;
                    }
                    if (refOut.equals(out)) continue;
                    dTLeaf.split((PTNode)sp.get(0), pTNode, a);
                    return true;
                }
            }
        }
        return super.makeConsistent();
    }

    private Word<O> lookupOrQuery(Word<I> prefix, Word<I> suffix) {
        Word<I> lookup = prefix.concat(suffix);
        Word<Object> out = this.outputs.get(lookup);
        if (out == null) {
            out = ((Word)this.mqOracle.answerQuery(prefix, suffix)).suffix(1);
            this.outputs.put(lookup, out);
        }
        return out;
    }
}

