/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.mealy;

import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.algorithm.oml.ttt.mealy.DecisionTreeMealy;
import de.learnlib.algorithm.oml.ttt.mealy.MealyTransition;
import de.learnlib.algorithm.oml.ttt.pt.PTNode;
import de.learnlib.algorithm.oml.ttt.pt.PrefixTree;
import java.util.Collection;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

class HypothesisMealy<I, O>
implements MealyMachine<DTLeaf<I, Word<O>>, I, MealyTransition<I, O>, O> {
    private final PrefixTree<I, Word<O>> ptree;
    private final DecisionTreeMealy<I, O> dtree;

    HypothesisMealy(PrefixTree<I, Word<O>> ptree, DecisionTreeMealy<I, O> dtree) {
        this.ptree = ptree;
        this.dtree = dtree;
    }

    @Override
    public Collection<DTLeaf<I, Word<O>>> getStates() {
        return this.dtree.leaves();
    }

    @Override
    public O getTransitionOutput(MealyTransition<I, O> o) {
        return this.dtree.getOutput(o.source, o.input).lastSymbol();
    }

    @Override
    public MealyTransition<I, O> getTransition(DTLeaf<I, Word<O>> iWordDTLeaf, I i) {
        return new MealyTransition<I, O>(iWordDTLeaf, i);
    }

    @Override
    public DTLeaf<I, Word<O>> getSuccessor(MealyTransition<I, O> o) {
        PTNode u = o.source.getShortPrefixes().get(0);
        assert (u != null);
        PTNode ua = u.succ(o.input);
        assert (ua != null);
        DTLeaf dst = ua.state();
        assert (dst != null);
        return dst;
    }

    @Override
    public DTLeaf<I, Word<O>> getInitialState() {
        return this.ptree.root().state();
    }
}

