/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.mealy;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.oml.ttt.AbstractOptimalTTT;
import de.learnlib.algorithm.oml.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.algorithm.oml.ttt.mealy.DecisionTreeMealy;
import de.learnlib.algorithm.oml.ttt.mealy.HypothesisMealy;
import de.learnlib.oracle.MembershipOracle;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

public class OptimalTTTMealy<I, O>
extends AbstractOptimalTTT<MealyMachine<?, I, ?, O>, I, Word<O>>
implements LearningAlgorithm.MealyLearner<I, O> {
    private final HypothesisMealy<I, O> hypothesis;
    private final DecisionTreeMealy<I, O> dtree;

    public OptimalTTTMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqo) {
        this(alphabet, mqo, mqo);
    }

    public OptimalTTTMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqs, MembershipOracle<I, Word<O>> ceqs) {
        super(alphabet, ceqs);
        this.dtree = new DecisionTreeMealy<I, O>(mqs, alphabet, this.strie.root());
        DTLeaf<I, O> dtRoot = new DTLeaf<I, O>(null, this.dtree, this.ptree.root());
        this.dtree.setRoot(dtRoot);
        this.ptree.root().setState(dtRoot);
        for (Object a : alphabet) {
            this.dtree.sift(this.ptree.root().append(a));
        }
        this.hypothesis = new HypothesisMealy<I, O>(this.ptree, this.dtree);
    }

    @Override
    protected int maxSearchIndex(int ceLength) {
        return ceLength - 1;
    }

    @Override
    protected Word<O> hypOutput(Word<I> word, int length) {
        return ((Word)this.hypothesis.computeOutput(word)).suffix(length);
    }

    @Override
    protected DTLeaf<I, Word<O>> getState(Word<I> prefix) {
        return (DTLeaf)this.hypothesis.getState(prefix);
    }

    @Override
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    @Override
    protected AbstractDecisionTree<I, Word<O>> dtree() {
        return this.dtree;
    }

    @Override
    protected Word<O> suffix(Word<O> output, int length) {
        return output.suffix(length);
    }

    @Override
    protected boolean isCanonical() {
        return this.hypothesis.getStates().stream().noneMatch(it -> it.getShortPrefixes().size() > 1);
    }
}

