/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.spa.manager;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.learnlib.AccessSequenceTransformer;
import de.learnlib.algorithm.procedural.spa.ATRManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.word.Word;

public class DefaultATRManager<I>
implements ATRManager<I> {
    private final Map<I, Word<I>> accessSequences;
    private final Map<I, Word<I>> returnSequences;
    private final Map<I, Word<I>> terminatingSequences;
    private final ProceduralInputAlphabet<I> alphabet;

    public DefaultATRManager(ProceduralInputAlphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.accessSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        this.returnSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        this.terminatingSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
    }

    @Override
    public Word<I> getAccessSequence(I procedure) {
        assert (this.accessSequences.containsKey(procedure));
        return this.accessSequences.get(procedure);
    }

    @Override
    public Word<I> getTerminatingSequence(I procedure) {
        assert (this.terminatingSequences.containsKey(procedure));
        return this.terminatingSequences.get(procedure);
    }

    @Override
    public Word<I> getReturnSequence(I procedure) {
        assert (this.returnSequences.containsKey(procedure));
        return this.returnSequences.get(procedure);
    }

    @Override
    public Set<I> scanPositiveCounterexample(Word<I> input) {
        HashSet<I> result = Sets.newHashSetWithExpectedSize(this.alphabet.getNumCalls() - this.accessSequences.size());
        for (int i = 0; i < input.size(); ++i) {
            I sym = input.getSymbol(i);
            if (!this.alphabet.isCallSymbol(sym) || this.accessSequences.containsKey(sym)) continue;
            int returnIdx = this.alphabet.findReturnIndex(input, i + 1);
            this.accessSequences.put(sym, input.prefix(i + 1));
            this.terminatingSequences.put(sym, input.subWord(i + 1, returnIdx));
            this.returnSequences.put(sym, input.subWord(returnIdx));
            result.add(sym);
        }
        return result;
    }

    @Override
    public void scanProcedures(Map<I, ? extends DFA<?, I>> procedures, Map<I, ? extends AccessSequenceTransformer<I>> providers, Collection<I> inputs) {
    }
}

