/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.spmm;

import de.learnlib.algorithm.procedural.SymbolWrapper;
import de.learnlib.algorithm.procedural.spmm.ATManager;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

class ProceduralMembershipOracle<I, O>
implements MembershipOracle<SymbolWrapper<I>, Word<O>> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final MembershipOracle<I, Word<O>> delegate;
    private final I procedure;
    private final O errorSymbol;
    private final ATManager<I, O> atManager;

    ProceduralMembershipOracle(ProceduralInputAlphabet<I> alphabet, MembershipOracle<I, Word<O>> delegate, I procedure, O errorSymbol, ATManager<I, O> atManager) {
        this.alphabet = alphabet;
        this.delegate = delegate;
        this.procedure = procedure;
        this.errorSymbol = errorSymbol;
        this.atManager = atManager;
    }

    @Override
    public void processQueries(Collection<? extends Query<SymbolWrapper<I>, Word<O>>> collection) {
        ArrayList<TransformedQuery> transformedQueries = new ArrayList<TransformedQuery>(collection.size());
        for (Query<SymbolWrapper<I>, Word<O>> q : collection) {
            if (this.hasErrorInPrefix(q.getPrefix())) {
                q.answer(Word.fromList(Collections.nCopies(q.getSuffix().length(), this.errorSymbol)));
                continue;
            }
            transformedQueries.add(new TransformedQuery(q));
        }
        this.delegate.processQueries(transformedQueries);
    }

    private Word<I> transformPrefix(Word<SymbolWrapper<I>> query) {
        WordBuilder<I> builder = new WordBuilder<I>();
        builder.append(this.atManager.getAccessSequence(this.procedure));
        for (SymbolWrapper<I> wrapper : query) {
            I i = wrapper.getDelegate();
            if (this.alphabet.isInternalSymbol(i)) {
                builder.append(i);
                continue;
            }
            if (this.alphabet.isCallSymbol(i)) {
                builder.append(i);
                builder.append(this.atManager.getTerminatingSequence(i));
                builder.append(this.alphabet.getReturnSymbol());
                continue;
            }
            throw new IllegalStateException("Prefixes should not contain return symbol");
        }
        return builder.toWord();
    }

    private Word<I> transformSuffix(Word<SymbolWrapper<I>> query, BitSet indices) {
        WordBuilder<I> builder = new WordBuilder<I>();
        for (SymbolWrapper<I> wrapper : query) {
            I i = wrapper.getDelegate();
            indices.set(builder.size());
            if (this.alphabet.isInternalSymbol(i)) {
                builder.append(i);
                continue;
            }
            if (this.alphabet.isCallSymbol(i)) {
                builder.append(i);
                if (wrapper.isContinuable()) {
                    builder.append(this.atManager.getTerminatingSequence(i));
                    builder.append(this.alphabet.getReturnSymbol());
                    continue;
                }
                return builder.toWord();
            }
            builder.append(i);
            return builder.toWord();
        }
        return builder.toWord();
    }

    private boolean hasErrorInPrefix(Word<SymbolWrapper<I>> prefix) {
        for (SymbolWrapper<I> wrapper : prefix) {
            if (wrapper.isContinuable()) continue;
            return true;
        }
        return false;
    }

    private class TransformedQuery
    extends Query<I, Word<O>> {
        private final Query<SymbolWrapper<I>, Word<O>> originalQuery;
        private final Word<I> transformedPrefix;
        private final Word<I> transformedSuffix;
        private final BitSet outputIndices;

        TransformedQuery(Query<SymbolWrapper<I>, Word<O>> originalQuery) {
            this.originalQuery = originalQuery;
            this.outputIndices = new BitSet();
            this.transformedPrefix = ProceduralMembershipOracle.this.transformPrefix(originalQuery.getPrefix());
            this.transformedSuffix = ProceduralMembershipOracle.this.transformSuffix(originalQuery.getSuffix(), this.outputIndices);
        }

        @Override
        public void answer(Word<O> output) {
            List out = this.outputIndices.stream().mapToObj(output::getSymbol).collect(Collectors.toList());
            for (int i = out.size(); i < this.originalQuery.getSuffix().size(); ++i) {
                out.add(ProceduralMembershipOracle.this.errorSymbol);
            }
            this.originalQuery.answer(Word.fromList(out));
        }

        @Override
        public Word<I> getPrefix() {
            return this.transformedPrefix;
        }

        @Override
        public Word<I> getSuffix() {
            return this.transformedSuffix;
        }
    }
}

